// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.dlm.model.DlmException
import aws.sdk.kotlin.services.dlm.model.GetLifecyclePoliciesResponse
import aws.sdk.kotlin.services.dlm.model.LifecyclePolicySummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetLifecyclePoliciesOperationDeserializer: HttpDeserialize<GetLifecyclePoliciesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLifecyclePoliciesResponse {
        if (!response.status.isSuccess()) {
            throwGetLifecyclePoliciesError(context, response)
        }
        val builder = GetLifecyclePoliciesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLifecyclePoliciesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetLifecyclePoliciesOperationBody(builder: GetLifecyclePoliciesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Policies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeList(POLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<LifecyclePolicySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLifecyclePolicySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetLifecyclePoliciesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DlmException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw DlmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
