// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * An attribute is a name-value pair that's associated with an Amazon ECS object. Use attributes to extend the Amazon ECS data model by adding custom metadata to your resources. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class Attribute private constructor(builder: Builder) {
    /**
     * The name of the attribute. The `name` must contain between 1 and 128 characters. The name may contain letters (uppercase and lowercase), numbers, hyphens (-), underscores (_), forward slashes (/), back slashes (\), or periods (.).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the target. You can specify the short form ID for a resource or the full Amazon Resource Name (ARN).
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * The type of the target to attach the attribute with. This parameter is required if you use the short form ID for a resource instead of the full ARN.
     */
    public val targetType: aws.sdk.kotlin.services.ecs.model.TargetType? = builder.targetType
    /**
     * The value of the attribute. The `value` must contain between 1 and 128 characters. It can contain letters (uppercase and lowercase), numbers, hyphens (-), underscores (_), periods (.), at signs (@), forward slashes (/), back slashes (\), colons (:), or spaces. The value can't start or end with a space.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Attribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Attribute(")
        append("name=$name,")
        append("targetId=$targetId,")
        append("targetType=$targetType,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Attribute

        if (name != other.name) return false
        if (targetId != other.targetId) return false
        if (targetType != other.targetType) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Attribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the attribute. The `name` must contain between 1 and 128 characters. The name may contain letters (uppercase and lowercase), numbers, hyphens (-), underscores (_), forward slashes (/), back slashes (\), or periods (.).
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the target. You can specify the short form ID for a resource or the full Amazon Resource Name (ARN).
         */
        public var targetId: kotlin.String? = null
        /**
         * The type of the target to attach the attribute with. This parameter is required if you use the short form ID for a resource instead of the full ARN.
         */
        public var targetType: aws.sdk.kotlin.services.ecs.model.TargetType? = null
        /**
         * The value of the attribute. The `value` must contain between 1 and 128 characters. It can contain letters (uppercase and lowercase), numbers, hyphens (-), underscores (_), periods (.), at signs (@), forward slashes (/), back slashes (\), colons (:), or spaces. The value can't start or end with a space.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Attribute) : this() {
            this.name = x.name
            this.targetId = x.targetId
            this.targetType = x.targetType
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Attribute = Attribute(this)
    }
}
