// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The details of the Auto Scaling group capacity provider to update.
 */
public class AutoScalingGroupProviderUpdate private constructor(builder: Builder) {
    /**
     * The managed scaling settings for the Auto Scaling group capacity provider.
     */
    public val managedScaling: aws.sdk.kotlin.services.ecs.model.ManagedScaling? = builder.managedScaling
    /**
     * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection.
     *
     * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
     *
     * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *Auto Scaling User Guide*.
     *
     * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
     */
    public val managedTerminationProtection: aws.sdk.kotlin.services.ecs.model.ManagedTerminationProtection? = builder.managedTerminationProtection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProviderUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupProviderUpdate(")
        append("managedScaling=$managedScaling,")
        append("managedTerminationProtection=$managedTerminationProtection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = managedScaling?.hashCode() ?: 0
        result = 31 * result + (managedTerminationProtection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupProviderUpdate

        if (managedScaling != other.managedScaling) return false
        if (managedTerminationProtection != other.managedTerminationProtection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProviderUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The managed scaling settings for the Auto Scaling group capacity provider.
         */
        public var managedScaling: aws.sdk.kotlin.services.ecs.model.ManagedScaling? = null
        /**
         * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection.
         *
         * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
         *
         * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *Auto Scaling User Guide*.
         *
         * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
         */
        public var managedTerminationProtection: aws.sdk.kotlin.services.ecs.model.ManagedTerminationProtection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProviderUpdate) : this() {
            this.managedScaling = x.managedScaling
            this.managedTerminationProtection = x.managedTerminationProtection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProviderUpdate = AutoScalingGroupProviderUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ManagedScaling] inside the given [block]
         */
        public fun managedScaling(block: aws.sdk.kotlin.services.ecs.model.ManagedScaling.Builder.() -> kotlin.Unit) {
            this.managedScaling = aws.sdk.kotlin.services.ecs.model.ManagedScaling.invoke(block)
        }
    }
}
