// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the `enabled` parameter to `true` in the `ServiceConnectConfiguration`. You can set the namespace of each service individually in the `ServiceConnectConfiguration` to override this default parameter.
 *
 * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class ClusterServiceConnectDefaults private constructor(builder: Builder) {
    /**
     * The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace. When you create a service and don't specify a Service Connect configuration, this namespace is used.
     */
    public val namespace: kotlin.String? = builder.namespace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterServiceConnectDefaults(")
        append("namespace=$namespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterServiceConnectDefaults

        if (namespace != other.namespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace. When you create a service and don't specify a Service Connect configuration, this namespace is used.
         */
        public var namespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults) : this() {
            this.namespace = x.namespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults = ClusterServiceConnectDefaults(this)
    }
}
