// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The settings to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster.
 */
public class ClusterSetting private constructor(builder: Builder) {
    /**
     * The name of the cluster setting. The value is `containerInsights` .
     */
    public val name: aws.sdk.kotlin.services.ecs.model.ClusterSettingName? = builder.name
    /**
     * The value to set for the cluster setting. The supported values are `enabled` and `disabled`.
     *
     * If you set `name` to `containerInsights` and `value` to `enabled`, CloudWatch Container Insights will be on for the cluster, otherwise it will be off unless the `containerInsights` account setting is turned on. If a cluster value is specified, it will override the `containerInsights` value set with [PutAccountSetting](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html) or [PutAccountSettingDefault](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html).
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ClusterSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSetting(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterSetting

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ClusterSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the cluster setting. The value is `containerInsights` .
         */
        public var name: aws.sdk.kotlin.services.ecs.model.ClusterSettingName? = null
        /**
         * The value to set for the cluster setting. The supported values are `enabled` and `disabled`.
         *
         * If you set `name` to `containerInsights` and `value` to `enabled`, CloudWatch Container Insights will be on for the cluster, otherwise it will be off unless the `containerInsights` account setting is turned on. If a cluster value is specified, it will override the `containerInsights` value set with [PutAccountSetting](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html) or [PutAccountSettingDefault](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html).
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ClusterSetting) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ClusterSetting = ClusterSetting(this)
    }
}
