// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * Container definitions are used in task definitions to describe the different containers that are launched as part of a task.
 */
public class ContainerDefinition private constructor(builder: Builder) {
    /**
     * The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `COMMAND` parameter to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.docker.com/engine/reference/builder/#cmd). If there are multiple arguments, each argument is a separated string in the array.
     */
    public val command: List<String>? = builder.command
    /**
     * The number of `cpu` units reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level `cpu` value.
     *
     * You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the [Amazon EC2 Instances](http://aws.amazon.com/ec2/instance-types/) detail page by 1,024.
     *
     * Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
     *
     * On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. For more information, see [CPU share constraint](https://docs.docker.com/engine/reference/run/#cpu-share-constraint) in the Docker documentation. The minimum valid CPU share value that the Linux kernel allows is 2. However, the CPU parameter isn't required, and you can use CPU values below 2 in your container definitions. For CPU values below 2 (including null), the behavior varies based on your Amazon ECS container agent version:
     * + **Agent versions less than or equal to 1.1.0:** Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.
     * + **Agent versions greater than or equal to 1.2.0:** Null, zero, and CPU values of 1 are passed to Docker as 2.
     *
     * On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as `0`, which Windows interprets as 1% of one CPU.
     */
    public val cpu: kotlin.Int = builder.cpu
    /**
     * A list of ARNs in SSM or Amazon S3 to a credential spec (`credspec`code>) file that configures a container for Active Directory authentication. This parameter is only used with domainless authentication.
     *
     * The format for each ARN is `credentialspecdomainless:MyARN`. Replace `MyARN` with the ARN in SSM or Amazon S3.
     *
     * The `credspec` must provide a ARN in Secrets Manager for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html).
     */
    public val credentialSpecs: List<String>? = builder.credentialSpecs
    /**
     * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies on other containers in a task definition. When a dependency is defined for container startup, for container shutdown it is reversed.
     *
     * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For tasks using the Fargate launch type, the task or service requires the following platforms:
     * + Linux platform version `1.3.0` or later.
     * + Windows platform version `1.0.0` or later.
     */
    public val dependsOn: List<ContainerDependency>? = builder.dependsOn
    /**
     * When this parameter is true, networking is off within the container. This parameter maps to `NetworkDisabled` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/).
     *
     * This parameter is not supported for Windows containers.
     */
    public val disableNetworking: kotlin.Boolean? = builder.disableNetworking
    /**
     * A list of DNS search domains that are presented to the container. This parameter maps to `DnsSearch` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--dns-search` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter is not supported for Windows containers.
     */
    public val dnsSearchDomains: List<String>? = builder.dnsSearchDomains
    /**
     * A list of DNS servers that are presented to the container. This parameter maps to `Dns` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--dns` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter is not supported for Windows containers.
     */
    public val dnsServers: List<String>? = builder.dnsServers
    /**
     * A key/value map of labels to add to the container. This parameter maps to `Labels` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--label` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
     */
    public val dockerLabels: Map<String, String>? = builder.dockerLabels
    /**
     * A list of strings to provide custom configuration for multiple security systems. For more information about valid values, see [Docker Run Security Configuration](https://docs.docker.com/engine/reference/run/#security-configuration). This field isn't valid for containers in tasks using the Fargate launch type.
     *
     * For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
     *
     * For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * This parameter maps to `SecurityOpt` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--security-opt` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * The Amazon ECS container agent running on a container instance must register with the `ECS_SELINUX_CAPABLE=true` or `ECS_APPARMOR_CAPABLE=true` environment variables before containers placed on that instance can use these security options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For more information about valid values, see [Docker Run Security Configuration](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
     */
    public val dockerSecurityOptions: List<String>? = builder.dockerSecurityOptions
    /**
     * Early versions of the Amazon ECS container agent don't properly handle `entryPoint` parameters. If you have problems using `entryPoint`, update your container agent or enter your commands and arguments as `command` array items instead.
     *
     * The entry point that's passed to the container. This parameter maps to `Entrypoint` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--entrypoint` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). For more information, see [https://docs.docker.com/engine/reference/builder/#entrypoint](https://docs.docker.com/engine/reference/builder/#entrypoint).
     */
    public val entryPoint: List<String>? = builder.entryPoint
    /**
     * The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--env` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
     */
    public val environment: List<KeyValuePair>? = builder.environment
    /**
     * A list of files containing the environment variables to pass to a container. This parameter maps to the `--env-file` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * You can specify up to ten environment files. The file must have a `.env` file extension. Each line in an environment file contains an environment variable in `VARIABLE=VALUE` format. Lines beginning with `#` are treated as comments and are ignored. For more information about the environment variable file syntax, see [Declare default environment variables in file](https://docs.docker.com/compose/env-file/).
     *
     * If there are environment variables specified using the `environment` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Specifying Environment Variables](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val environmentFiles: List<EnvironmentFile>? = builder.environmentFiles
    /**
     * If the `essential` parameter of a container is marked as `true`, and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as `false`, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
     *
     * All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val essential: kotlin.Boolean? = builder.essential
    /**
     * A list of hostnames and IP address mappings to append to the `/etc/hosts` file on the container. This parameter maps to `ExtraHosts` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--add-host` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter isn't supported for Windows containers or tasks that use the `awsvpc` network mode.
     */
    public val extraHosts: List<HostEntry>? = builder.extraHosts
    /**
     * The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom Log Routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val firelensConfiguration: aws.sdk.kotlin.services.ecs.model.FirelensConfiguration? = builder.firelensConfiguration
    /**
     * The container health check command and associated configuration parameters for the container. This parameter maps to `HealthCheck` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `HEALTHCHECK` parameter of [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val healthCheck: aws.sdk.kotlin.services.ecs.model.HealthCheck? = builder.healthCheck
    /**
     * The hostname to use for your container. This parameter maps to `Hostname` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--hostname` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * The `hostname` parameter is not supported if you're using the `awsvpc` network mode.
     */
    public val hostname: kotlin.String? = builder.hostname
    /**
     * The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either ` <i>repository-url</i>/<i>image</i>:<i>tag</i> ` or ` <i>repository-url</i>/<i>image</i>@<i>digest</i> `. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     * + When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.
     * + Images in Amazon ECR repositories can be specified by either using the full `registry/repository:tag` or `registry/repository@digest`. For example, `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest` or `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE`.
     * + Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo`).
     * + Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent`).
     * + Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu`).
     */
    public val image: kotlin.String? = builder.image
    /**
     * When this parameter is `true`, you can deploy containerized applications that require `stdin` or a `tty` to be allocated. This parameter maps to `OpenStdin` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--interactive` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val interactive: kotlin.Boolean? = builder.interactive
    /**
     * The `links` parameter allows containers to communicate with each other without the need for port mappings. This parameter is only supported if the network mode of a task definition is `bridge`. The `name:internalName` construct is analogous to `name:alias` in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. For more information about linking Docker containers, go to [Legacy container links](https://docs.docker.com/network/links/) in the Docker documentation. This parameter maps to `Links` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--link` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter is not supported for Windows containers.
     *
     * Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
     */
    public val links: List<String>? = builder.links
    /**
     * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see KernelCapabilities.
     *
     * This parameter is not supported for Windows containers.
     */
    public val linuxParameters: aws.sdk.kotlin.services.ecs.model.LinuxParameters? = builder.linuxParameters
    /**
     * The log configuration specification for the container.
     *
     * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
     *
     * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
     *
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
     *
     * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val logConfiguration: aws.sdk.kotlin.services.ecs.model.LogConfiguration? = builder.logConfiguration
    /**
     * The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task `memory` value, if one is specified. This parameter maps to `Memory` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--memory` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If using the Fargate launch type, this parameter is optional.
     *
     * If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level `memory` and `memoryReservation` value, `memory` must be greater than `memoryReservation`. If you specify `memoryReservation`, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of `memory` is used.
     *
     * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
     *
     * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
     */
    public val memory: kotlin.Int? = builder.memory
    /**
     * The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the `memory` parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to `MemoryReservation` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--memory-reservation` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If a task-level memory value is not specified, you must specify a non-zero integer for one or both of `memory` or `memoryReservation` in a container definition. If you specify both, `memory` must be greater than `memoryReservation`. If you specify `memoryReservation`, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of `memory` is used.
     *
     * For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a `memoryReservation` of 128 MiB, and a `memory` hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
     *
     * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
     *
     * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
     */
    public val memoryReservation: kotlin.Int? = builder.memoryReservation
    /**
     * The mount points for data volumes in your container.
     *
     * This parameter maps to `Volumes` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--volume` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * Windows containers can mount whole directories on the same drive as `$env:ProgramData`. Windows containers can't mount directories on a different drive, and mount point can't be across drives.
     */
    public val mountPoints: List<MountPoint>? = builder.mountPoints
    /**
     * The name of a container. If you're linking multiple containers together in a task definition, the `name` of one container can be entered in the `links` of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to `name` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--name` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of port mappings for the container. Port mappings allow containers to access ports on the host container instance to send or receive traffic.
     *
     * For task definitions that use the `awsvpc` network mode, only specify the `containerPort`. The `hostPort` can be left blank or it must be the same value as the `containerPort`.
     *
     * Port mappings on Windows use the `NetNAT` gateway address rather than `localhost`. There's no loopback for port mappings on Windows, so you can't access a container's mapped port from the host itself.
     *
     * This parameter maps to `PortBindings` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--publish` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). If the network mode of a task definition is set to `none`, then you can't specify port mappings. If the network mode of a task definition is set to `host`, then host ports must either be undefined or they must match the container port in the port mapping.
     *
     * After a task reaches the `RUNNING` status, manual and automatic host and container port assignments are visible in the **Network Bindings** section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the `networkBindings` section DescribeTasks responses.
     */
    public val portMappings: List<PortMapping>? = builder.portMappings
    /**
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter is not supported for Windows containers or tasks run on Fargate.
     */
    public val privileged: kotlin.Boolean? = builder.privileged
    /**
     * When this parameter is `true`, a TTY is allocated. This parameter maps to `Tty` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--tty` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val pseudoTerminal: kotlin.Boolean? = builder.pseudoTerminal
    /**
     * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * This parameter is not supported for Windows containers.
     */
    public val readonlyRootFilesystem: kotlin.Boolean? = builder.readonlyRootFilesystem
    /**
     * The private repository authentication credentials to use.
     */
    public val repositoryCredentials: aws.sdk.kotlin.services.ecs.model.RepositoryCredentials? = builder.repositoryCredentials
    /**
     * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     */
    public val resourceRequirements: List<ResourceRequirement>? = builder.resourceRequirements
    /**
     * The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val secrets: List<Secret>? = builder.secrets
    /**
     * Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a `COMPLETE`, `SUCCESS`, or `HEALTHY` status. If a `startTimeout` value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a `STOPPED` state.
     *
     * When the `ECS_CONTAINER_START_TIMEOUT` container agent configuration variable is used, it's enforced independently from this start timeout value.
     *
     * For tasks using the Fargate launch type, the task or service requires the following platforms:
     * + Linux platform version `1.3.0` or later.
     * + Windows platform version `1.0.0` or later.
     *
     * For tasks using the EC2 launch type, your container instances require at least version `1.26.0` of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version `1.26.0-1` of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val startTimeout: kotlin.Int? = builder.startTimeout
    /**
     * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
     *
     * For tasks using the Fargate launch type, the task or service requires the following platforms:
     * + Linux platform version `1.3.0` or later.
     * + Windows platform version `1.0.0` or later.
     *
     * The max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
     *
     * For tasks that use the EC2 launch type, if the `stopTimeout` parameter isn't specified, the value set for the Amazon ECS container agent configuration variable `ECS_CONTAINER_STOP_TIMEOUT` is used. If neither the `stopTimeout` parameter or the `ECS_CONTAINER_STOP_TIMEOUT` agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val stopTimeout: kotlin.Int? = builder.stopTimeout
    /**
     * A list of namespaced kernel parameters to set in the container. This parameter maps to `Sysctls` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--sysctl` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * We don't recommended that you specify network-related `systemControls` parameters for multiple containers in a single task that also uses either the `awsvpc` or `host` network modes. For tasks that use the `awsvpc` network mode, the container that's started last determines which `systemControls` parameters take effect. For tasks that use the `host` network mode, it changes the container instance's namespaced kernel parameters as well as the containers.
     */
    public val systemControls: List<SystemControl>? = builder.systemControls
    /**
     * A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). Valid naming values are displayed in the Ulimit data type.
     *
     * Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the `nofile` resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `4096`.
     *
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
     *
     * This parameter is not supported for Windows containers.
     */
    public val ulimits: List<Ulimit>? = builder.ulimits
    /**
     * The user to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * When running tasks using the `host` network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
     *
     * You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
     * + `user`
     * + `user:group`
     * + `uid`
     * + `uid:gid`
     * + `user:gid`
     * + `uid:group`
     *
     * This parameter is not supported for Windows containers.
     */
    public val user: kotlin.String? = builder.user
    /**
     * Data volumes to mount from another container. This parameter maps to `VolumesFrom` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--volumes-from` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val volumesFrom: List<VolumeFrom>? = builder.volumesFrom
    /**
     * The working directory to run commands inside the container in. This parameter maps to `WorkingDir` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--workdir` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     */
    public val workingDirectory: kotlin.String? = builder.workingDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDefinition(")
        append("command=$command,")
        append("cpu=$cpu,")
        append("credentialSpecs=$credentialSpecs,")
        append("dependsOn=$dependsOn,")
        append("disableNetworking=$disableNetworking,")
        append("dnsSearchDomains=$dnsSearchDomains,")
        append("dnsServers=$dnsServers,")
        append("dockerLabels=$dockerLabels,")
        append("dockerSecurityOptions=$dockerSecurityOptions,")
        append("entryPoint=$entryPoint,")
        append("environment=$environment,")
        append("environmentFiles=$environmentFiles,")
        append("essential=$essential,")
        append("extraHosts=$extraHosts,")
        append("firelensConfiguration=$firelensConfiguration,")
        append("healthCheck=$healthCheck,")
        append("hostname=$hostname,")
        append("image=$image,")
        append("interactive=$interactive,")
        append("links=$links,")
        append("linuxParameters=$linuxParameters,")
        append("logConfiguration=$logConfiguration,")
        append("memory=$memory,")
        append("memoryReservation=$memoryReservation,")
        append("mountPoints=$mountPoints,")
        append("name=$name,")
        append("portMappings=$portMappings,")
        append("privileged=$privileged,")
        append("pseudoTerminal=$pseudoTerminal,")
        append("readonlyRootFilesystem=$readonlyRootFilesystem,")
        append("repositoryCredentials=$repositoryCredentials,")
        append("resourceRequirements=$resourceRequirements,")
        append("secrets=$secrets,")
        append("startTimeout=$startTimeout,")
        append("stopTimeout=$stopTimeout,")
        append("systemControls=$systemControls,")
        append("ulimits=$ulimits,")
        append("user=$user,")
        append("volumesFrom=$volumesFrom,")
        append("workingDirectory=$workingDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (cpu)
        result = 31 * result + (credentialSpecs?.hashCode() ?: 0)
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (disableNetworking?.hashCode() ?: 0)
        result = 31 * result + (dnsSearchDomains?.hashCode() ?: 0)
        result = 31 * result + (dnsServers?.hashCode() ?: 0)
        result = 31 * result + (dockerLabels?.hashCode() ?: 0)
        result = 31 * result + (dockerSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (entryPoint?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (environmentFiles?.hashCode() ?: 0)
        result = 31 * result + (essential?.hashCode() ?: 0)
        result = 31 * result + (extraHosts?.hashCode() ?: 0)
        result = 31 * result + (firelensConfiguration?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (interactive?.hashCode() ?: 0)
        result = 31 * result + (links?.hashCode() ?: 0)
        result = 31 * result + (linuxParameters?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (memoryReservation ?: 0)
        result = 31 * result + (mountPoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (portMappings?.hashCode() ?: 0)
        result = 31 * result + (privileged?.hashCode() ?: 0)
        result = 31 * result + (pseudoTerminal?.hashCode() ?: 0)
        result = 31 * result + (readonlyRootFilesystem?.hashCode() ?: 0)
        result = 31 * result + (repositoryCredentials?.hashCode() ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (secrets?.hashCode() ?: 0)
        result = 31 * result + (startTimeout ?: 0)
        result = 31 * result + (stopTimeout ?: 0)
        result = 31 * result + (systemControls?.hashCode() ?: 0)
        result = 31 * result + (ulimits?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        result = 31 * result + (volumesFrom?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDefinition

        if (command != other.command) return false
        if (cpu != other.cpu) return false
        if (credentialSpecs != other.credentialSpecs) return false
        if (dependsOn != other.dependsOn) return false
        if (disableNetworking != other.disableNetworking) return false
        if (dnsSearchDomains != other.dnsSearchDomains) return false
        if (dnsServers != other.dnsServers) return false
        if (dockerLabels != other.dockerLabels) return false
        if (dockerSecurityOptions != other.dockerSecurityOptions) return false
        if (entryPoint != other.entryPoint) return false
        if (environment != other.environment) return false
        if (environmentFiles != other.environmentFiles) return false
        if (essential != other.essential) return false
        if (extraHosts != other.extraHosts) return false
        if (firelensConfiguration != other.firelensConfiguration) return false
        if (healthCheck != other.healthCheck) return false
        if (hostname != other.hostname) return false
        if (image != other.image) return false
        if (interactive != other.interactive) return false
        if (links != other.links) return false
        if (linuxParameters != other.linuxParameters) return false
        if (logConfiguration != other.logConfiguration) return false
        if (memory != other.memory) return false
        if (memoryReservation != other.memoryReservation) return false
        if (mountPoints != other.mountPoints) return false
        if (name != other.name) return false
        if (portMappings != other.portMappings) return false
        if (privileged != other.privileged) return false
        if (pseudoTerminal != other.pseudoTerminal) return false
        if (readonlyRootFilesystem != other.readonlyRootFilesystem) return false
        if (repositoryCredentials != other.repositoryCredentials) return false
        if (resourceRequirements != other.resourceRequirements) return false
        if (secrets != other.secrets) return false
        if (startTimeout != other.startTimeout) return false
        if (stopTimeout != other.stopTimeout) return false
        if (systemControls != other.systemControls) return false
        if (ulimits != other.ulimits) return false
        if (user != other.user) return false
        if (volumesFrom != other.volumesFrom) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `COMMAND` parameter to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.docker.com/engine/reference/builder/#cmd). If there are multiple arguments, each argument is a separated string in the array.
         */
        public var command: List<String>? = null
        /**
         * The number of `cpu` units reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level `cpu` value.
         *
         * You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the [Amazon EC2 Instances](http://aws.amazon.com/ec2/instance-types/) detail page by 1,024.
         *
         * Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
         *
         * On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. For more information, see [CPU share constraint](https://docs.docker.com/engine/reference/run/#cpu-share-constraint) in the Docker documentation. The minimum valid CPU share value that the Linux kernel allows is 2. However, the CPU parameter isn't required, and you can use CPU values below 2 in your container definitions. For CPU values below 2 (including null), the behavior varies based on your Amazon ECS container agent version:
         * + **Agent versions less than or equal to 1.1.0:** Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.
         * + **Agent versions greater than or equal to 1.2.0:** Null, zero, and CPU values of 1 are passed to Docker as 2.
         *
         * On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as `0`, which Windows interprets as 1% of one CPU.
         */
        public var cpu: kotlin.Int = 0
        /**
         * A list of ARNs in SSM or Amazon S3 to a credential spec (`credspec`code>) file that configures a container for Active Directory authentication. This parameter is only used with domainless authentication.
         *
         * The format for each ARN is `credentialspecdomainless:MyARN`. Replace `MyARN` with the ARN in SSM or Amazon S3.
         *
         * The `credspec` must provide a ARN in Secrets Manager for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html).
         */
        public var credentialSpecs: List<String>? = null
        /**
         * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies on other containers in a task definition. When a dependency is defined for container startup, for container shutdown it is reversed.
         *
         * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * + Linux platform version `1.3.0` or later.
         * + Windows platform version `1.0.0` or later.
         */
        public var dependsOn: List<ContainerDependency>? = null
        /**
         * When this parameter is true, networking is off within the container. This parameter maps to `NetworkDisabled` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/).
         *
         * This parameter is not supported for Windows containers.
         */
        public var disableNetworking: kotlin.Boolean? = null
        /**
         * A list of DNS search domains that are presented to the container. This parameter maps to `DnsSearch` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--dns-search` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter is not supported for Windows containers.
         */
        public var dnsSearchDomains: List<String>? = null
        /**
         * A list of DNS servers that are presented to the container. This parameter maps to `Dns` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--dns` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter is not supported for Windows containers.
         */
        public var dnsServers: List<String>? = null
        /**
         * A key/value map of labels to add to the container. This parameter maps to `Labels` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--label` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
         */
        public var dockerLabels: Map<String, String>? = null
        /**
         * A list of strings to provide custom configuration for multiple security systems. For more information about valid values, see [Docker Run Security Configuration](https://docs.docker.com/engine/reference/run/#security-configuration). This field isn't valid for containers in tasks using the Fargate launch type.
         *
         * For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
         *
         * For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * This parameter maps to `SecurityOpt` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--security-opt` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * The Amazon ECS container agent running on a container instance must register with the `ECS_SELINUX_CAPABLE=true` or `ECS_APPARMOR_CAPABLE=true` environment variables before containers placed on that instance can use these security options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * For more information about valid values, see [Docker Run Security Configuration](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
         */
        public var dockerSecurityOptions: List<String>? = null
        /**
         * Early versions of the Amazon ECS container agent don't properly handle `entryPoint` parameters. If you have problems using `entryPoint`, update your container agent or enter your commands and arguments as `command` array items instead.
         *
         * The entry point that's passed to the container. This parameter maps to `Entrypoint` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--entrypoint` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). For more information, see [https://docs.docker.com/engine/reference/builder/#entrypoint](https://docs.docker.com/engine/reference/builder/#entrypoint).
         */
        public var entryPoint: List<String>? = null
        /**
         * The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--env` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
         */
        public var environment: List<KeyValuePair>? = null
        /**
         * A list of files containing the environment variables to pass to a container. This parameter maps to the `--env-file` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * You can specify up to ten environment files. The file must have a `.env` file extension. Each line in an environment file contains an environment variable in `VARIABLE=VALUE` format. Lines beginning with `#` are treated as comments and are ignored. For more information about the environment variable file syntax, see [Declare default environment variables in file](https://docs.docker.com/compose/env-file/).
         *
         * If there are environment variables specified using the `environment` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Specifying Environment Variables](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var environmentFiles: List<EnvironmentFile>? = null
        /**
         * If the `essential` parameter of a container is marked as `true`, and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as `false`, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
         *
         * All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var essential: kotlin.Boolean? = null
        /**
         * A list of hostnames and IP address mappings to append to the `/etc/hosts` file on the container. This parameter maps to `ExtraHosts` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--add-host` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter isn't supported for Windows containers or tasks that use the `awsvpc` network mode.
         */
        public var extraHosts: List<HostEntry>? = null
        /**
         * The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom Log Routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var firelensConfiguration: aws.sdk.kotlin.services.ecs.model.FirelensConfiguration? = null
        /**
         * The container health check command and associated configuration parameters for the container. This parameter maps to `HealthCheck` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `HEALTHCHECK` parameter of [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var healthCheck: aws.sdk.kotlin.services.ecs.model.HealthCheck? = null
        /**
         * The hostname to use for your container. This parameter maps to `Hostname` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--hostname` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * The `hostname` parameter is not supported if you're using the `awsvpc` network mode.
         */
        public var hostname: kotlin.String? = null
        /**
         * The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either ` <i>repository-url</i>/<i>image</i>:<i>tag</i> ` or ` <i>repository-url</i>/<i>image</i>@<i>digest</i> `. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         * + When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.
         * + Images in Amazon ECR repositories can be specified by either using the full `registry/repository:tag` or `registry/repository@digest`. For example, `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest` or `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE`.
         * + Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo`).
         * + Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent`).
         * + Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu`).
         */
        public var image: kotlin.String? = null
        /**
         * When this parameter is `true`, you can deploy containerized applications that require `stdin` or a `tty` to be allocated. This parameter maps to `OpenStdin` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--interactive` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var interactive: kotlin.Boolean? = null
        /**
         * The `links` parameter allows containers to communicate with each other without the need for port mappings. This parameter is only supported if the network mode of a task definition is `bridge`. The `name:internalName` construct is analogous to `name:alias` in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. For more information about linking Docker containers, go to [Legacy container links](https://docs.docker.com/network/links/) in the Docker documentation. This parameter maps to `Links` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--link` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter is not supported for Windows containers.
         *
         * Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
         */
        public var links: List<String>? = null
        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see KernelCapabilities.
         *
         * This parameter is not supported for Windows containers.
         */
        public var linuxParameters: aws.sdk.kotlin.services.ecs.model.LinuxParameters? = null
        /**
         * The log configuration specification for the container.
         *
         * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
         *
         * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
         *
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
         *
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var logConfiguration: aws.sdk.kotlin.services.ecs.model.LogConfiguration? = null
        /**
         * The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task `memory` value, if one is specified. This parameter maps to `Memory` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--memory` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If using the Fargate launch type, this parameter is optional.
         *
         * If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level `memory` and `memoryReservation` value, `memory` must be greater than `memoryReservation`. If you specify `memoryReservation`, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of `memory` is used.
         *
         * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
         *
         * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
         */
        public var memory: kotlin.Int? = null
        /**
         * The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the `memory` parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to `MemoryReservation` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--memory-reservation` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If a task-level memory value is not specified, you must specify a non-zero integer for one or both of `memory` or `memoryReservation` in a container definition. If you specify both, `memory` must be greater than `memoryReservation`. If you specify `memoryReservation`, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of `memory` is used.
         *
         * For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a `memoryReservation` of 128 MiB, and a `memory` hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
         *
         * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
         *
         * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
         */
        public var memoryReservation: kotlin.Int? = null
        /**
         * The mount points for data volumes in your container.
         *
         * This parameter maps to `Volumes` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--volume` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * Windows containers can mount whole directories on the same drive as `$env:ProgramData`. Windows containers can't mount directories on a different drive, and mount point can't be across drives.
         */
        public var mountPoints: List<MountPoint>? = null
        /**
         * The name of a container. If you're linking multiple containers together in a task definition, the `name` of one container can be entered in the `links` of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to `name` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--name` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var name: kotlin.String? = null
        /**
         * The list of port mappings for the container. Port mappings allow containers to access ports on the host container instance to send or receive traffic.
         *
         * For task definitions that use the `awsvpc` network mode, only specify the `containerPort`. The `hostPort` can be left blank or it must be the same value as the `containerPort`.
         *
         * Port mappings on Windows use the `NetNAT` gateway address rather than `localhost`. There's no loopback for port mappings on Windows, so you can't access a container's mapped port from the host itself.
         *
         * This parameter maps to `PortBindings` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--publish` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). If the network mode of a task definition is set to `none`, then you can't specify port mappings. If the network mode of a task definition is set to `host`, then host ports must either be undefined or they must match the container port in the port mapping.
         *
         * After a task reaches the `RUNNING` status, manual and automatic host and container port assignments are visible in the **Network Bindings** section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the `networkBindings` section DescribeTasks responses.
         */
        public var portMappings: List<PortMapping>? = null
        /**
         * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter is not supported for Windows containers or tasks run on Fargate.
         */
        public var privileged: kotlin.Boolean? = null
        /**
         * When this parameter is `true`, a TTY is allocated. This parameter maps to `Tty` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--tty` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var pseudoTerminal: kotlin.Boolean? = null
        /**
         * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * This parameter is not supported for Windows containers.
         */
        public var readonlyRootFilesystem: kotlin.Boolean? = null
        /**
         * The private repository authentication credentials to use.
         */
        public var repositoryCredentials: aws.sdk.kotlin.services.ecs.model.RepositoryCredentials? = null
        /**
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         */
        public var resourceRequirements: List<ResourceRequirement>? = null
        /**
         * The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var secrets: List<Secret>? = null
        /**
         * Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a `COMPLETE`, `SUCCESS`, or `HEALTHY` status. If a `startTimeout` value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a `STOPPED` state.
         *
         * When the `ECS_CONTAINER_START_TIMEOUT` container agent configuration variable is used, it's enforced independently from this start timeout value.
         *
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * + Linux platform version `1.3.0` or later.
         * + Windows platform version `1.0.0` or later.
         *
         * For tasks using the EC2 launch type, your container instances require at least version `1.26.0` of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version `1.26.0-1` of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var startTimeout: kotlin.Int? = null
        /**
         * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         *
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * + Linux platform version `1.3.0` or later.
         * + Windows platform version `1.0.0` or later.
         *
         * The max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
         *
         * For tasks that use the EC2 launch type, if the `stopTimeout` parameter isn't specified, the value set for the Amazon ECS container agent configuration variable `ECS_CONTAINER_STOP_TIMEOUT` is used. If neither the `stopTimeout` parameter or the `ECS_CONTAINER_STOP_TIMEOUT` agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var stopTimeout: kotlin.Int? = null
        /**
         * A list of namespaced kernel parameters to set in the container. This parameter maps to `Sysctls` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--sysctl` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * We don't recommended that you specify network-related `systemControls` parameters for multiple containers in a single task that also uses either the `awsvpc` or `host` network modes. For tasks that use the `awsvpc` network mode, the container that's started last determines which `systemControls` parameters take effect. For tasks that use the `host` network mode, it changes the container instance's namespaced kernel parameters as well as the containers.
         */
        public var systemControls: List<SystemControl>? = null
        /**
         * A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). Valid naming values are displayed in the Ulimit data type.
         *
         * Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the `nofile` resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `4096`.
         *
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
         *
         * This parameter is not supported for Windows containers.
         */
        public var ulimits: List<Ulimit>? = null
        /**
         * The user to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * When running tasks using the `host` network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
         *
         * You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
         * + `user`
         * + `user:group`
         * + `uid`
         * + `uid:gid`
         * + `user:gid`
         * + `uid:group`
         *
         * This parameter is not supported for Windows containers.
         */
        public var user: kotlin.String? = null
        /**
         * Data volumes to mount from another container. This parameter maps to `VolumesFrom` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--volumes-from` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var volumesFrom: List<VolumeFrom>? = null
        /**
         * The working directory to run commands inside the container in. This parameter maps to `WorkingDir` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--workdir` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         */
        public var workingDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerDefinition) : this() {
            this.command = x.command
            this.cpu = x.cpu
            this.credentialSpecs = x.credentialSpecs
            this.dependsOn = x.dependsOn
            this.disableNetworking = x.disableNetworking
            this.dnsSearchDomains = x.dnsSearchDomains
            this.dnsServers = x.dnsServers
            this.dockerLabels = x.dockerLabels
            this.dockerSecurityOptions = x.dockerSecurityOptions
            this.entryPoint = x.entryPoint
            this.environment = x.environment
            this.environmentFiles = x.environmentFiles
            this.essential = x.essential
            this.extraHosts = x.extraHosts
            this.firelensConfiguration = x.firelensConfiguration
            this.healthCheck = x.healthCheck
            this.hostname = x.hostname
            this.image = x.image
            this.interactive = x.interactive
            this.links = x.links
            this.linuxParameters = x.linuxParameters
            this.logConfiguration = x.logConfiguration
            this.memory = x.memory
            this.memoryReservation = x.memoryReservation
            this.mountPoints = x.mountPoints
            this.name = x.name
            this.portMappings = x.portMappings
            this.privileged = x.privileged
            this.pseudoTerminal = x.pseudoTerminal
            this.readonlyRootFilesystem = x.readonlyRootFilesystem
            this.repositoryCredentials = x.repositoryCredentials
            this.resourceRequirements = x.resourceRequirements
            this.secrets = x.secrets
            this.startTimeout = x.startTimeout
            this.stopTimeout = x.stopTimeout
            this.systemControls = x.systemControls
            this.ulimits = x.ulimits
            this.user = x.user
            this.volumesFrom = x.volumesFrom
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerDefinition = ContainerDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.FirelensConfiguration] inside the given [block]
         */
        public fun firelensConfiguration(block: aws.sdk.kotlin.services.ecs.model.FirelensConfiguration.Builder.() -> kotlin.Unit) {
            this.firelensConfiguration = aws.sdk.kotlin.services.ecs.model.FirelensConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.HealthCheck] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.ecs.model.HealthCheck.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.ecs.model.HealthCheck.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.LinuxParameters] inside the given [block]
         */
        public fun linuxParameters(block: aws.sdk.kotlin.services.ecs.model.LinuxParameters.Builder.() -> kotlin.Unit) {
            this.linuxParameters = aws.sdk.kotlin.services.ecs.model.LinuxParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.ecs.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.ecs.model.LogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.RepositoryCredentials] inside the given [block]
         */
        public fun repositoryCredentials(block: aws.sdk.kotlin.services.ecs.model.RepositoryCredentials.Builder.() -> kotlin.Unit) {
            this.repositoryCredentials = aws.sdk.kotlin.services.ecs.model.RepositoryCredentials.invoke(block)
        }
    }
}
