// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * The capacity provider strategy to use for the service.
     *
     * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
     *
     * A capacity provider strategy may contain a maximum of 6 capacity providers.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = builder.deploymentConfiguration
    /**
     * The deployment controller to use for the service. If no deployment controller is specified, the default value of `ECS` is used.
     */
    public val deploymentController: aws.sdk.kotlin.services.ecs.model.DeploymentController? = builder.deploymentController
    /**
     * The number of instantiations of the specified task definition to place and keep running in your service.
     *
     * This is required if `schedulingStrategy` is `REPLICA` or isn't specified. If `schedulingStrategy` is `DAEMON` then this isn't required.
     */
    public val desiredCount: kotlin.Int? = builder.desiredCount
    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see [Tagging your Amazon ECS resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * When you use Amazon ECS managed tags, you need to set the `propagateTags` request parameter.
     */
    public val enableEcsManagedTags: kotlin.Boolean = builder.enableEcsManagedTags
    /**
     * Determines whether the execute command functionality is turned on for the service. If `true`, this enables execute command functionality on all containers in the service tasks.
     */
    public val enableExecuteCommand: kotlin.Boolean = builder.enableExecuteCommand
    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of `0` is used.
     *
     * If you do not use an Elastic Load Balancing, we recommend that you use the `startPeriod` in the task definition health check parameters. For more information, see [Health check](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html).
     *
     * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     */
    public val healthCheckGracePeriodSeconds: kotlin.Int? = builder.healthCheckGracePeriodSeconds
    /**
     * The infrastructure that you run your service on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * The `FARGATE` launch type runs your tasks on Fargate On-Demand infrastructure.
     *
     * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see [Fargate capacity providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html) in the *Amazon ECS User Guide for Fargate*.
     *
     * The `EC2` launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     *
     * The `EXTERNAL` launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.
     *
     * A service can use either a launch type or a capacity provider strategy. If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * A load balancer object representing the load balancers to use with your service. For more information, see [Service load balancing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If the service uses the rolling update (`ECS`) deployment controller and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service. The service-linked role is required for services that use multiple target groups. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If the service uses the `CODE_DEPLOY` deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two target groups (referred to as a `targetGroupPair`). During a deployment, CodeDeploy determines which task set in your service has the status `PRIMARY`, and it associates one target group with it. Then, it also associates the other target group with the replacement task set. The load balancer can also have up to two listeners: a required listener for production traffic and an optional listener that you can use to perform validation tests with Lambda functions before routing production traffic to it.
     *
     * If you use the `CODE_DEPLOY` deployment controller, these values can be changed when updating the service.
     *
     * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN, the container name, and the container port to access from the load balancer. The container name must be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from this service is placed on a container instance, the container instance and port combination is registered as a target in the target group that's specified here.
     *
     * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the container port to access from the load balancer. The container name must be as it appears in a container definition. The target group ARN parameter must be omitted. When a task from this service is placed on a container instance, the container instance is registered with the load balancer that's specified here.
     *
     * Services with tasks that use the `awsvpc` network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't supported. Also, when you create any target groups for these services, you must choose `ip` as the target type, not `instance`. This is because tasks that use the `awsvpc` network mode are associated with an elastic network interface, not an Amazon EC2 instance.
     */
    public val loadBalancers: List<LoadBalancer>? = builder.loadBalancers
    /**
     * The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see [Task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    public val placementConstraints: List<PlacementConstraint>? = builder.placementConstraints
    /**
     * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules for each service.
     */
    public val placementStrategy: List<PlacementStrategy>? = builder.placementStrategy
    /**
     * The platform version that your tasks in the service are running on. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the [TagResource](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
     *
     * The default is `NONE`.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the `awsvpc` network mode. If you specify the `role` parameter, you must also specify a load balancer object with the `loadBalancers` parameter.
     *
     * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the `awsvpc` network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If your specified role has a path other than `/`, then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name `bar` has a path of `/foo/` then you would specify `/foo/bar` as the role name. For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide*.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
     *
     * There are two service scheduler strategies available:
     * + `REPLICA`-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the `CODE_DEPLOY` or `EXTERNAL` deployment controller types.
     * + `DAEMON`-The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy.
     */
    public val schedulingStrategy: aws.sdk.kotlin.services.ecs.model.SchedulingStrategy? = builder.schedulingStrategy
    /**
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     *
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = builder.serviceConnectConfiguration
    /**
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
     *
     * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
     */
    public val serviceRegistries: List<ServiceRegistry>? = builder.serviceRegistries
    /**
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run in your service. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
     *
     * A task definition must be specified if the service uses either the `ECS` or `CODE_DEPLOY` deployment controllers.
     *
     * For more information about deployment types, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html).
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("clientToken=$clientToken,")
        append("cluster=$cluster,")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("deploymentController=$deploymentController,")
        append("desiredCount=$desiredCount,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("healthCheckGracePeriodSeconds=$healthCheckGracePeriodSeconds,")
        append("launchType=$launchType,")
        append("loadBalancers=$loadBalancers,")
        append("networkConfiguration=$networkConfiguration,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategy=$placementStrategy,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("role=$role,")
        append("schedulingStrategy=$schedulingStrategy,")
        append("serviceConnectConfiguration=$serviceConnectConfiguration,")
        append("serviceName=$serviceName,")
        append("serviceRegistries=$serviceRegistries,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentController?.hashCode() ?: 0)
        result = 31 * result + (desiredCount ?: 0)
        result = 31 * result + (enableEcsManagedTags.hashCode())
        result = 31 * result + (enableExecuteCommand.hashCode())
        result = 31 * result + (healthCheckGracePeriodSeconds ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (schedulingStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceConnectConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (clientToken != other.clientToken) return false
        if (cluster != other.cluster) return false
        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (deploymentController != other.deploymentController) return false
        if (desiredCount != other.desiredCount) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (healthCheckGracePeriodSeconds != other.healthCheckGracePeriodSeconds) return false
        if (launchType != other.launchType) return false
        if (loadBalancers != other.loadBalancers) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategy != other.placementStrategy) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (role != other.role) return false
        if (schedulingStrategy != other.schedulingStrategy) return false
        if (serviceConnectConfiguration != other.serviceConnectConfiguration) return false
        if (serviceName != other.serviceName) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.CreateServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity provider strategy to use for the service.
         *
         * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
         *
         * A capacity provider strategy may contain a maximum of 6 capacity providers.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = null
        /**
         * The deployment controller to use for the service. If no deployment controller is specified, the default value of `ECS` is used.
         */
        public var deploymentController: aws.sdk.kotlin.services.ecs.model.DeploymentController? = null
        /**
         * The number of instantiations of the specified task definition to place and keep running in your service.
         *
         * This is required if `schedulingStrategy` is `REPLICA` or isn't specified. If `schedulingStrategy` is `DAEMON` then this isn't required.
         */
        public var desiredCount: kotlin.Int? = null
        /**
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see [Tagging your Amazon ECS resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * When you use Amazon ECS managed tags, you need to set the `propagateTags` request parameter.
         */
        public var enableEcsManagedTags: kotlin.Boolean = false
        /**
         * Determines whether the execute command functionality is turned on for the service. If `true`, this enables execute command functionality on all containers in the service tasks.
         */
        public var enableExecuteCommand: kotlin.Boolean = false
        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of `0` is used.
         *
         * If you do not use an Elastic Load Balancing, we recommend that you use the `startPeriod` in the task definition health check parameters. For more information, see [Health check](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html).
         *
         * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
         */
        public var healthCheckGracePeriodSeconds: kotlin.Int? = null
        /**
         * The infrastructure that you run your service on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * The `FARGATE` launch type runs your tasks on Fargate On-Demand infrastructure.
         *
         * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see [Fargate capacity providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html) in the *Amazon ECS User Guide for Fargate*.
         *
         * The `EC2` launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         *
         * The `EXTERNAL` launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.
         *
         * A service can use either a launch type or a capacity provider strategy. If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * A load balancer object representing the load balancers to use with your service. For more information, see [Service load balancing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If the service uses the rolling update (`ECS`) deployment controller and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service. The service-linked role is required for services that use multiple target groups. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If the service uses the `CODE_DEPLOY` deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two target groups (referred to as a `targetGroupPair`). During a deployment, CodeDeploy determines which task set in your service has the status `PRIMARY`, and it associates one target group with it. Then, it also associates the other target group with the replacement task set. The load balancer can also have up to two listeners: a required listener for production traffic and an optional listener that you can use to perform validation tests with Lambda functions before routing production traffic to it.
         *
         * If you use the `CODE_DEPLOY` deployment controller, these values can be changed when updating the service.
         *
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN, the container name, and the container port to access from the load balancer. The container name must be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from this service is placed on a container instance, the container instance and port combination is registered as a target in the target group that's specified here.
         *
         * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the container port to access from the load balancer. The container name must be as it appears in a container definition. The target group ARN parameter must be omitted. When a task from this service is placed on a container instance, the container instance is registered with the load balancer that's specified here.
         *
         * Services with tasks that use the `awsvpc` network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't supported. Also, when you create any target groups for these services, you must choose `ip` as the target type, not `instance`. This is because tasks that use the `awsvpc` network mode are associated with an elastic network interface, not an Amazon EC2 instance.
         */
        public var loadBalancers: List<LoadBalancer>? = null
        /**
         * The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see [Task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         */
        public var placementConstraints: List<PlacementConstraint>? = null
        /**
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules for each service.
         */
        public var placementStrategy: List<PlacementStrategy>? = null
        /**
         * The platform version that your tasks in the service are running on. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the [TagResource](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
         *
         * The default is `NONE`.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the `awsvpc` network mode. If you specify the `role` parameter, you must also specify a load balancer object with the `loadBalancers` parameter.
         *
         * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the `awsvpc` network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If your specified role has a path other than `/`, then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name `bar` has a path of `/foo/` then you would specify `/foo/bar` as the role name. For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide*.
         */
        public var role: kotlin.String? = null
        /**
         * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
         *
         * There are two service scheduler strategies available:
         * + `REPLICA`-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the `CODE_DEPLOY` or `EXTERNAL` deployment controller types.
         * + `DAEMON`-The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy.
         */
        public var schedulingStrategy: aws.sdk.kotlin.services.ecs.model.SchedulingStrategy? = null
        /**
         * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         *
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = null
        /**
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
         *
         * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
         */
        public var serviceRegistries: List<ServiceRegistry>? = null
        /**
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run in your service. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
         *
         * A task definition must be specified if the service uses either the `ECS` or `CODE_DEPLOY` deployment controllers.
         *
         * For more information about deployment types, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html).
         */
        public var taskDefinition: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.CreateServiceRequest) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.clientToken = x.clientToken
            this.cluster = x.cluster
            this.deploymentConfiguration = x.deploymentConfiguration
            this.deploymentController = x.deploymentController
            this.desiredCount = x.desiredCount
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.healthCheckGracePeriodSeconds = x.healthCheckGracePeriodSeconds
            this.launchType = x.launchType
            this.loadBalancers = x.loadBalancers
            this.networkConfiguration = x.networkConfiguration
            this.placementConstraints = x.placementConstraints
            this.placementStrategy = x.placementStrategy
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.role = x.role
            this.schedulingStrategy = x.schedulingStrategy
            this.serviceConnectConfiguration = x.serviceConnectConfiguration
            this.serviceName = x.serviceName
            this.serviceRegistries = x.serviceRegistries
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.CreateServiceRequest = CreateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentController] inside the given [block]
         */
        public fun deploymentController(block: aws.sdk.kotlin.services.ecs.model.DeploymentController.Builder.() -> kotlin.Unit) {
            this.deploymentController = aws.sdk.kotlin.services.ecs.model.DeploymentController.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration] inside the given [block]
         */
        public fun serviceConnectConfiguration(block: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceConnectConfiguration = aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.invoke(block)
        }
    }
}
