// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The deployment circuit breaker can only be used for services using the rolling update (`ECS`) deployment type.
 *
 * The **deployment circuit breaker** determines whether a service deployment will fail if the service can't reach a steady state. If it is turned on, a service deployment will transition to a failed state and stop launching new tasks. You can also configure Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class DeploymentCircuitBreaker private constructor(builder: Builder) {
    /**
     * Determines whether to use the deployment circuit breaker logic for the service.
     */
    public val enable: kotlin.Boolean = builder.enable
    /**
     * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    public val rollback: kotlin.Boolean = builder.rollback

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.DeploymentCircuitBreaker = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentCircuitBreaker(")
        append("enable=$enable,")
        append("rollback=$rollback")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enable.hashCode()
        result = 31 * result + (rollback.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentCircuitBreaker

        if (enable != other.enable) return false
        if (rollback != other.rollback) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.DeploymentCircuitBreaker = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether to use the deployment circuit breaker logic for the service.
         */
        public var enable: kotlin.Boolean = false
        /**
         * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
         */
        public var rollback: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.DeploymentCircuitBreaker) : this() {
            this.enable = x.enable
            this.rollback = x.rollback
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.DeploymentCircuitBreaker = DeploymentCircuitBreaker(this)
    }
}
