// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class DescribeContainerInstancesRequest private constructor(builder: Builder) {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
     */
    public val containerInstances: List<String>? = builder.containerInstances
    /**
     * Specifies whether you want to see the resource tags for the container instance. If `TAGS` is specified, the tags are included in the response. If `CONTAINER_INSTANCE_HEALTH` is specified, the container instance health is included in the response. If this field is omitted, tags and container instance health status aren't included in the response.
     */
    public val include: List<ContainerInstanceField>? = builder.include

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeContainerInstancesRequest(")
        append("cluster=$cluster,")
        append("containerInstances=$containerInstances,")
        append("include=$include")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (containerInstances?.hashCode() ?: 0)
        result = 31 * result + (include?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeContainerInstancesRequest

        if (cluster != other.cluster) return false
        if (containerInstances != other.containerInstances) return false
        if (include != other.include) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster.
         */
        public var cluster: kotlin.String? = null
        /**
         * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         */
        public var containerInstances: List<String>? = null
        /**
         * Specifies whether you want to see the resource tags for the container instance. If `TAGS` is specified, the tags are included in the response. If `CONTAINER_INSTANCE_HEALTH` is specified, the container instance health is included in the response. If this field is omitted, tags and container instance health status aren't included in the response.
         */
        public var include: List<ContainerInstanceField>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesRequest) : this() {
            this.cluster = x.cluster
            this.containerInstances = x.containerInstances
            this.include = x.include
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesRequest = DescribeContainerInstancesRequest(this)
    }
}
