// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * This parameter is specified when you're using Docker volumes. Docker volumes are only supported when you're using the EC2 launch type. Windows containers only support the use of the `local` driver. To use bind mounts, specify a `host` instead.
 */
public class DockerVolumeConfiguration private constructor(builder: Builder) {
    /**
     * If this value is `true`, the Docker volume is created if it doesn't already exist.
     *
     * This field is only used if the `scope` is `shared`.
     */
    public val autoprovision: kotlin.Boolean? = builder.autoprovision
    /**
     * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use `docker plugin ls` to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. For more information, see [Docker plugin discovery](https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery). This parameter maps to `Driver` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxdriver` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
     */
    public val driver: kotlin.String? = builder.driver
    /**
     * A map of Docker driver-specific options passed through. This parameter maps to `DriverOpts` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxopt` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
     */
    public val driverOpts: Map<String, String>? = builder.driverOpts
    /**
     * Custom metadata to add to your Docker volume. This parameter maps to `Labels` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxlabel` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
     */
    public val labels: Map<String, String>? = builder.labels
    /**
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
     */
    public val scope: aws.sdk.kotlin.services.ecs.model.Scope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DockerVolumeConfiguration(")
        append("autoprovision=$autoprovision,")
        append("driver=$driver,")
        append("driverOpts=$driverOpts,")
        append("labels=$labels,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoprovision?.hashCode() ?: 0
        result = 31 * result + (driver?.hashCode() ?: 0)
        result = 31 * result + (driverOpts?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DockerVolumeConfiguration

        if (autoprovision != other.autoprovision) return false
        if (driver != other.driver) return false
        if (driverOpts != other.driverOpts) return false
        if (labels != other.labels) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If this value is `true`, the Docker volume is created if it doesn't already exist.
         *
         * This field is only used if the `scope` is `shared`.
         */
        public var autoprovision: kotlin.Boolean? = null
        /**
         * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use `docker plugin ls` to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. For more information, see [Docker plugin discovery](https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery). This parameter maps to `Driver` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxdriver` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
         */
        public var driver: kotlin.String? = null
        /**
         * A map of Docker driver-specific options passed through. This parameter maps to `DriverOpts` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxopt` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
         */
        public var driverOpts: Map<String, String>? = null
        /**
         * Custom metadata to add to your Docker volume. This parameter maps to `Labels` in the [Create a volume](https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `xxlabel` option to [docker volume create](https://docs.docker.com/engine/reference/commandline/volume_create/).
         */
        public var labels: Map<String, String>? = null
        /**
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
         */
        public var scope: aws.sdk.kotlin.services.ecs.model.Scope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration) : this() {
            this.autoprovision = x.autoprovision
            this.driver = x.driver
            this.driverOpts = x.driverOpts
            this.labels = x.labels
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration = DockerVolumeConfiguration(this)
    }
}
