// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The Linux-specific options that are applied to the container, such as Linux [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
 */
public class LinuxParameters private constructor(builder: Builder) {
    /**
     * The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
     *
     * For tasks that use the Fargate launch type, `capabilities` is supported for all platform versions but the `add` parameter is only supported if using platform version 1.4.0 or later.
     */
    public val capabilities: aws.sdk.kotlin.services.ecs.model.KernelCapabilities? = builder.capabilities
    /**
     * Any host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--device` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If you're using tasks that use the Fargate launch type, the `devices` parameter isn't supported.
     */
    public val devices: List<Device>? = builder.devices
    /**
     * Run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
     */
    public val initProcessEnabled: kotlin.Boolean? = builder.initProcessEnabled
    /**
     * The total amount of swap memory (in MiB) a container can use. This parameter will be translated to the `--memory-swap` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration) where the value would be the sum of the container memory plus the `maxSwap` value.
     *
     * If a `maxSwap` value of `0` is specified, the container will not use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container will use the swap configuration for the container instance it is running on. A `maxSwap` value must be set for the `swappiness` parameter to be used.
     *
     * If you're using tasks that use the Fargate launch type, the `maxSwap` parameter isn't supported.
     *
     * If you're using tasks on Amazon Linux 2023 the `swappiness` parameter isn't supported.
     */
    public val maxSwap: kotlin.Int? = builder.maxSwap
    /**
     * The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If you are using tasks that use the Fargate launch type, the `sharedMemorySize` parameter is not supported.
     */
    public val sharedMemorySize: kotlin.Int? = builder.sharedMemorySize
    /**
     * This allows you to tune a container's memory swappiness behavior. A `swappiness` value of `0` will cause swapping to not happen unless absolutely necessary. A `swappiness` value of `100` will cause pages to be swapped very aggressively. Accepted values are whole numbers between `0` and `100`. If the `swappiness` parameter is not specified, a default value of `60` is used. If a value is not specified for `maxSwap` then this parameter is ignored. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If you're using tasks that use the Fargate launch type, the `swappiness` parameter isn't supported.
     *
     * If you're using tasks on Amazon Linux 2023 the `swappiness` parameter isn't supported.
     */
    public val swappiness: kotlin.Int? = builder.swappiness
    /**
     * The container path, mount options, and size (in MiB) of the tmpfs mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
     *
     * If you're using tasks that use the Fargate launch type, the `tmpfs` parameter isn't supported.
     */
    public val tmpfs: List<Tmpfs>? = builder.tmpfs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.LinuxParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LinuxParameters(")
        append("capabilities=$capabilities,")
        append("devices=$devices,")
        append("initProcessEnabled=$initProcessEnabled,")
        append("maxSwap=$maxSwap,")
        append("sharedMemorySize=$sharedMemorySize,")
        append("swappiness=$swappiness,")
        append("tmpfs=$tmpfs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (devices?.hashCode() ?: 0)
        result = 31 * result + (initProcessEnabled?.hashCode() ?: 0)
        result = 31 * result + (maxSwap ?: 0)
        result = 31 * result + (sharedMemorySize ?: 0)
        result = 31 * result + (swappiness ?: 0)
        result = 31 * result + (tmpfs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LinuxParameters

        if (capabilities != other.capabilities) return false
        if (devices != other.devices) return false
        if (initProcessEnabled != other.initProcessEnabled) return false
        if (maxSwap != other.maxSwap) return false
        if (sharedMemorySize != other.sharedMemorySize) return false
        if (swappiness != other.swappiness) return false
        if (tmpfs != other.tmpfs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.LinuxParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
         *
         * For tasks that use the Fargate launch type, `capabilities` is supported for all platform versions but the `add` parameter is only supported if using platform version 1.4.0 or later.
         */
        public var capabilities: aws.sdk.kotlin.services.ecs.model.KernelCapabilities? = null
        /**
         * Any host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--device` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If you're using tasks that use the Fargate launch type, the `devices` parameter isn't supported.
         */
        public var devices: List<Device>? = null
        /**
         * Run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
         */
        public var initProcessEnabled: kotlin.Boolean? = null
        /**
         * The total amount of swap memory (in MiB) a container can use. This parameter will be translated to the `--memory-swap` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration) where the value would be the sum of the container memory plus the `maxSwap` value.
         *
         * If a `maxSwap` value of `0` is specified, the container will not use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container will use the swap configuration for the container instance it is running on. A `maxSwap` value must be set for the `swappiness` parameter to be used.
         *
         * If you're using tasks that use the Fargate launch type, the `maxSwap` parameter isn't supported.
         *
         * If you're using tasks on Amazon Linux 2023 the `swappiness` parameter isn't supported.
         */
        public var maxSwap: kotlin.Int? = null
        /**
         * The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If you are using tasks that use the Fargate launch type, the `sharedMemorySize` parameter is not supported.
         */
        public var sharedMemorySize: kotlin.Int? = null
        /**
         * This allows you to tune a container's memory swappiness behavior. A `swappiness` value of `0` will cause swapping to not happen unless absolutely necessary. A `swappiness` value of `100` will cause pages to be swapped very aggressively. Accepted values are whole numbers between `0` and `100`. If the `swappiness` parameter is not specified, a default value of `60` is used. If a value is not specified for `maxSwap` then this parameter is ignored. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If you're using tasks that use the Fargate launch type, the `swappiness` parameter isn't supported.
         *
         * If you're using tasks on Amazon Linux 2023 the `swappiness` parameter isn't supported.
         */
        public var swappiness: kotlin.Int? = null
        /**
         * The container path, mount options, and size (in MiB) of the tmpfs mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
         *
         * If you're using tasks that use the Fargate launch type, the `tmpfs` parameter isn't supported.
         */
        public var tmpfs: List<Tmpfs>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.LinuxParameters) : this() {
            this.capabilities = x.capabilities
            this.devices = x.devices
            this.initProcessEnabled = x.initProcessEnabled
            this.maxSwap = x.maxSwap
            this.sharedMemorySize = x.sharedMemorySize
            this.swappiness = x.swappiness
            this.tmpfs = x.tmpfs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.LinuxParameters = LinuxParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.KernelCapabilities] inside the given [block]
         */
        public fun capabilities(block: aws.sdk.kotlin.services.ecs.model.KernelCapabilities.Builder.() -> kotlin.Unit) {
            this.capabilities = aws.sdk.kotlin.services.ecs.model.KernelCapabilities.invoke(block)
        }
    }
}
