// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class ListAccountSettingsRequest private constructor(builder: Builder) {
    /**
     * Determines whether to return the effective settings. If `true`, the account settings for the root user or the default setting for the `principalArn` are returned. If `false`, the account settings for the `principalArn` are returned if they're set. Otherwise, no account settings are returned.
     */
    public val effectiveSettings: kotlin.Boolean = builder.effectiveSettings
    /**
     * The maximum number of account setting results returned by `ListAccountSettings` in paginated output. When this parameter is used, `ListAccountSettings` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListAccountSettings` request with the returned `nextToken` value. This value can be between 1 and 10. If this parameter isn't used, then `ListAccountSettings` returns up to 10 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * The name of the account setting you want to list the settings for.
     */
    public val name: aws.sdk.kotlin.services.ecs.model.SettingName? = builder.name
    /**
     * The `nextToken` value returned from a `ListAccountSettings` request indicating that more results are available to fulfill the request and further calls will be needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN of the principal, which can be a user, role, or the root user. If this field is omitted, the account settings are listed only for the authenticated user.
     *
     * Federated users assume the account setting of the root user and can't have explicit account settings set for them.
     */
    public val principalArn: kotlin.String? = builder.principalArn
    /**
     * The value of the account settings to filter results with. You must also specify an account setting name to use this parameter.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccountSettingsRequest(")
        append("effectiveSettings=$effectiveSettings,")
        append("maxResults=$maxResults,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("principalArn=$principalArn,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = effectiveSettings.hashCode()
        result = 31 * result + (maxResults)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAccountSettingsRequest

        if (effectiveSettings != other.effectiveSettings) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (principalArn != other.principalArn) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether to return the effective settings. If `true`, the account settings for the root user or the default setting for the `principalArn` are returned. If `false`, the account settings for the `principalArn` are returned if they're set. Otherwise, no account settings are returned.
         */
        public var effectiveSettings: kotlin.Boolean = false
        /**
         * The maximum number of account setting results returned by `ListAccountSettings` in paginated output. When this parameter is used, `ListAccountSettings` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListAccountSettings` request with the returned `nextToken` value. This value can be between 1 and 10. If this parameter isn't used, then `ListAccountSettings` returns up to 10 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * The name of the account setting you want to list the settings for.
         */
        public var name: aws.sdk.kotlin.services.ecs.model.SettingName? = null
        /**
         * The `nextToken` value returned from a `ListAccountSettings` request indicating that more results are available to fulfill the request and further calls will be needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN of the principal, which can be a user, role, or the root user. If this field is omitted, the account settings are listed only for the authenticated user.
         *
         * Federated users assume the account setting of the root user and can't have explicit account settings set for them.
         */
        public var principalArn: kotlin.String? = null
        /**
         * The value of the account settings to filter results with. You must also specify an account setting name to use this parameter.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest) : this() {
            this.effectiveSettings = x.effectiveSettings
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.principalArn = x.principalArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest = ListAccountSettingsRequest(this)
    }
}
