// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class ListAttributesRequest private constructor(builder: Builder) {
    /**
     * The name of the attribute to filter the results with.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.
     */
    public val attributeValue: kotlin.String? = builder.attributeValue
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The maximum number of cluster results that `ListAttributes` returned in paginated output. When this parameter is used, `ListAttributes` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListAttributes` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListAttributes` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a `ListAttributes` request indicating that more results are available to fulfill the request and further calls are needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of the target to list attributes with.
     */
    public val targetType: aws.sdk.kotlin.services.ecs.model.TargetType? = builder.targetType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ListAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAttributesRequest(")
        append("attributeName=$attributeName,")
        append("attributeValue=$attributeValue,")
        append("cluster=$cluster,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("targetType=$targetType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValue?.hashCode() ?: 0)
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAttributesRequest

        if (attributeName != other.attributeName) return false
        if (attributeValue != other.attributeValue) return false
        if (cluster != other.cluster) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (targetType != other.targetType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ListAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the attribute to filter the results with.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.
         */
        public var attributeValue: kotlin.String? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The maximum number of cluster results that `ListAttributes` returned in paginated output. When this parameter is used, `ListAttributes` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListAttributes` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListAttributes` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a `ListAttributes` request indicating that more results are available to fulfill the request and further calls are needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of the target to list attributes with.
         */
        public var targetType: aws.sdk.kotlin.services.ecs.model.TargetType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ListAttributesRequest) : this() {
            this.attributeName = x.attributeName
            this.attributeValue = x.attributeValue
            this.cluster = x.cluster
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.targetType = x.targetType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ListAttributesRequest = ListAttributesRequest(this)
    }
}
