// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class RunTaskRequest private constructor(builder: Builder) {
    /**
     * The capacity provider strategy to use for the task.
     *
     * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
     *
     * When you use cluster auto scaling, you must specify `capacityProviderStrategy` and not `launchType`.
     *
     * A capacity provider strategy may contain a maximum of 6 capacity providers.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster to run your task on. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
     */
    public val count: kotlin.Int? = builder.count
    /**
     * Specifies whether to use Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val enableEcsManagedTags: kotlin.Boolean = builder.enableEcsManagedTags
    /**
     * Determines whether to use the execute command functionality for the containers in this task. If `true`, this enables execute command functionality on all containers in the task.
     *
     * If `true`, then the task definition must have a task role, or you must provide one as an override.
     */
    public val enableExecuteCommand: kotlin.Boolean = builder.enableExecuteCommand
    /**
     * The name of the task group to associate with the task. The default value is the family name of the task definition (for example, `family:my-family-name`).
     */
    public val group: kotlin.String? = builder.group
    /**
     * The infrastructure to run your standalone task on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * The `FARGATE` launch type runs your tasks on Fargate On-Demand infrastructure.
     *
     * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see [Fargate capacity providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html) in the *Amazon ECS User Guide for Fargate*.
     *
     * The `EC2` launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     *
     * The `EXTERNAL` launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.
     *
     * A task can use either a launch type or a capacity provider strategy. If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
     *
     * When you use cluster auto scaling, you must specify `capacityProviderStrategy` and not `launchType`.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * The network configuration for the task. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see [Task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that's specified in the task definition or Docker image) with a `command` override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an `environment` override.
     *
     * A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.
     */
    public val overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = builder.overrides
    /**
     * An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task (including constraints in the task definition and those specified at runtime).
     */
    public val placementConstraints: List<PlacementConstraint>? = builder.placementConstraints
    /**
     * The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task.
     */
    public val placementStrategy: List<PlacementStrategy>? = builder.placementStrategy
    /**
     * The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
     *
     * An error will be received if you specify the `SERVICE` option when running a task.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The reference ID to use for the task. The reference ID can have a maximum length of 1024 characters.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the `startedBy` parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.
     *
     * If a task is started by an Amazon ECS service, then the `startedBy` parameter contains the deployment ID of the service that starts it.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
     *
     * When you create a policy for run-task, you can set the resource to be the latest task definition revision, or a specific revision.
     *
     * The full ARN value must match the value that you specified as the `Resource` of the principal's permissions policy.
     *
     * When you specify the policy resource as the latest task definition version (by setting the `Resource` in the policy to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`), then set this value to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`.
     *
     * When you specify the policy resource as a specific task definition version (by setting the `Resource` in the policy to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1` or `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*`), then set this value to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1`.
     *
     * For more information, see [Policy Resources for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources) in the Amazon Elastic Container Service developer Guide.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.RunTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunTaskRequest(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("cluster=$cluster,")
        append("count=$count,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("group=$group,")
        append("launchType=$launchType,")
        append("networkConfiguration=$networkConfiguration,")
        append("overrides=$overrides,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategy=$placementStrategy,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("referenceId=$referenceId,")
        append("startedBy=$startedBy,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (count ?: 0)
        result = 31 * result + (enableEcsManagedTags.hashCode())
        result = 31 * result + (enableExecuteCommand.hashCode())
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (referenceId?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunTaskRequest

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (cluster != other.cluster) return false
        if (count != other.count) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (group != other.group) return false
        if (launchType != other.launchType) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (overrides != other.overrides) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategy != other.placementStrategy) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (referenceId != other.referenceId) return false
        if (startedBy != other.startedBy) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.RunTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity provider strategy to use for the task.
         *
         * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
         *
         * When you use cluster auto scaling, you must specify `capacityProviderStrategy` and not `launchType`.
         *
         * A capacity provider strategy may contain a maximum of 6 capacity providers.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster to run your task on. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
         */
        public var count: kotlin.Int? = null
        /**
         * Specifies whether to use Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var enableEcsManagedTags: kotlin.Boolean = false
        /**
         * Determines whether to use the execute command functionality for the containers in this task. If `true`, this enables execute command functionality on all containers in the task.
         *
         * If `true`, then the task definition must have a task role, or you must provide one as an override.
         */
        public var enableExecuteCommand: kotlin.Boolean = false
        /**
         * The name of the task group to associate with the task. The default value is the family name of the task definition (for example, `family:my-family-name`).
         */
        public var group: kotlin.String? = null
        /**
         * The infrastructure to run your standalone task on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * The `FARGATE` launch type runs your tasks on Fargate On-Demand infrastructure.
         *
         * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see [Fargate capacity providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html) in the *Amazon ECS User Guide for Fargate*.
         *
         * The `EC2` launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         *
         * The `EXTERNAL` launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.
         *
         * A task can use either a launch type or a capacity provider strategy. If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
         *
         * When you use cluster auto scaling, you must specify `capacityProviderStrategy` and not `launchType`.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * The network configuration for the task. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see [Task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that's specified in the task definition or Docker image) with a `command` override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an `environment` override.
         *
         * A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.
         */
        public var overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = null
        /**
         * An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task (including constraints in the task definition and those specified at runtime).
         */
        public var placementConstraints: List<PlacementConstraint>? = null
        /**
         * The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task.
         */
        public var placementStrategy: List<PlacementStrategy>? = null
        /**
         * The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
         *
         * An error will be received if you specify the `SERVICE` option when running a task.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The reference ID to use for the task. The reference ID can have a maximum length of 1024 characters.
         */
        public var referenceId: kotlin.String? = null
        /**
         * An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the `startedBy` parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.
         *
         * If a task is started by an Amazon ECS service, then the `startedBy` parameter contains the deployment ID of the service that starts it.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
         *
         * When you create a policy for run-task, you can set the resource to be the latest task definition revision, or a specific revision.
         *
         * The full ARN value must match the value that you specified as the `Resource` of the principal's permissions policy.
         *
         * When you specify the policy resource as the latest task definition version (by setting the `Resource` in the policy to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`), then set this value to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`.
         *
         * When you specify the policy resource as a specific task definition version (by setting the `Resource` in the policy to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1` or `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*`), then set this value to `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1`.
         *
         * For more information, see [Policy Resources for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources) in the Amazon Elastic Container Service developer Guide.
         */
        public var taskDefinition: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.RunTaskRequest) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.cluster = x.cluster
            this.count = x.count
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.group = x.group
            this.launchType = x.launchType
            this.networkConfiguration = x.networkConfiguration
            this.overrides = x.overrides
            this.placementConstraints = x.placementConstraints
            this.placementStrategy = x.placementStrategy
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.referenceId = x.referenceId
            this.startedBy = x.startedBy
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.RunTaskRequest = RunTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TaskOverride] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.ecs.model.TaskOverride.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.ecs.model.TaskOverride.invoke(block)
        }
    }
}
