// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details on a service within a cluster.
 */
public class Service private constructor(builder: Builder) {
    /**
     * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted if the service was created using a launch type.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * The Amazon Resource Name (ARN) of the cluster that hosts the service.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The Unix timestamp for the time when the service was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The principal that created the service.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = builder.deploymentConfiguration
    /**
     * The deployment controller type the service is using.
     */
    public val deploymentController: aws.sdk.kotlin.services.ecs.model.DeploymentController? = builder.deploymentController
    /**
     * The current state of deployments for the service.
     */
    public val deployments: List<Deployment>? = builder.deployments
    /**
     * The desired number of instantiations of the task definition to keep running on the service. This value is specified when the service is created with CreateService, and it can be modified with UpdateService.
     */
    public val desiredCount: kotlin.Int = builder.desiredCount
    /**
     * Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val enableEcsManagedTags: kotlin.Boolean = builder.enableEcsManagedTags
    /**
     * Determines whether the execute command functionality is turned on for the service. If `true`, the execute command functionality is turned on for all containers in tasks as part of the service.
     */
    public val enableExecuteCommand: kotlin.Boolean = builder.enableExecuteCommand
    /**
     * The event stream for your service. A maximum of 100 of the latest events are displayed.
     */
    public val events: List<ServiceEvent>? = builder.events
    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     */
    public val healthCheckGracePeriodSeconds: kotlin.Int? = builder.healthCheckGracePeriodSeconds
    /**
     * The launch type the service is using. When using the DescribeServices API, this field is omitted if the service was created using a capacity provider strategy.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.
     */
    public val loadBalancers: List<LoadBalancer>? = builder.loadBalancers
    /**
     * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The number of tasks in the cluster that are in the `PENDING` state.
     */
    public val pendingCount: kotlin.Int = builder.pendingCount
    /**
     * The placement constraints for the tasks in the service.
     */
    public val placementConstraints: List<PlacementConstraint>? = builder.placementConstraints
    /**
     * The placement strategy that determines how tasks for the service are placed.
     */
    public val placementStrategy: List<PlacementStrategy>? = builder.placementStrategy
    /**
     * The operating system that your tasks in the service run on. A platform family is specified only for tasks using the Fargate launch type.
     *
     *  All tasks that run as part of this service must use the same `platformFamily` value as the service (for example, `LINUX`).
     */
    public val platformFamily: kotlin.String? = builder.platformFamily
    /**
     * The platform version to run your service on. A platform version is only specified for tasks that are hosted on Fargate. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The number of tasks in the cluster that are in the `RUNNING` state.
     */
    public val runningCount: kotlin.Int = builder.runningCount
    /**
     * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
     *
     * There are two service scheduler strategies available.
     * + `REPLICA`-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions.
     * + `DAEMON`-The daemon scheduling strategy deploys exactly one task on each active container instance. This task meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the placement constraints.Fargate tasks don't support the `DAEMON` scheduling strategy.
     */
    public val schedulingStrategy: aws.sdk.kotlin.services.ecs.model.SchedulingStrategy? = builder.schedulingStrategy
    /**
     * The ARN that identifies the service. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster. However, you can have similarly named services in multiple clusters within a Region or across multiple Regions.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The details for the service discovery registries to assign to this service. For more information, see [Service Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
     */
    public val serviceRegistries: List<ServiceRegistry>? = builder.serviceRegistries
    /**
     * The status of the service. The valid values are `ACTIVE`, `DRAINING`, or `INACTIVE`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value. You define bot the key and value.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The task definition to use for tasks in the service. This value is specified when the service is created with CreateService, and it can be modified with UpdateService.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition
    /**
     * Information about a set of Amazon ECS tasks in either an CodeDeploy or an `EXTERNAL` deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.
     */
    public val taskSets: List<TaskSet>? = builder.taskSets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Service = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Service(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("clusterArn=$clusterArn,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("deploymentController=$deploymentController,")
        append("deployments=$deployments,")
        append("desiredCount=$desiredCount,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("events=$events,")
        append("healthCheckGracePeriodSeconds=$healthCheckGracePeriodSeconds,")
        append("launchType=$launchType,")
        append("loadBalancers=$loadBalancers,")
        append("networkConfiguration=$networkConfiguration,")
        append("pendingCount=$pendingCount,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategy=$placementStrategy,")
        append("platformFamily=$platformFamily,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("roleArn=$roleArn,")
        append("runningCount=$runningCount,")
        append("schedulingStrategy=$schedulingStrategy,")
        append("serviceArn=$serviceArn,")
        append("serviceName=$serviceName,")
        append("serviceRegistries=$serviceRegistries,")
        append("status=$status,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition,")
        append("taskSets=$taskSets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentController?.hashCode() ?: 0)
        result = 31 * result + (deployments?.hashCode() ?: 0)
        result = 31 * result + (desiredCount)
        result = 31 * result + (enableEcsManagedTags.hashCode())
        result = 31 * result + (enableExecuteCommand.hashCode())
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriodSeconds ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pendingCount)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        result = 31 * result + (platformFamily?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (runningCount)
        result = 31 * result + (schedulingStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        result = 31 * result + (taskSets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Service

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (clusterArn != other.clusterArn) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (deploymentController != other.deploymentController) return false
        if (deployments != other.deployments) return false
        if (desiredCount != other.desiredCount) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (events != other.events) return false
        if (healthCheckGracePeriodSeconds != other.healthCheckGracePeriodSeconds) return false
        if (launchType != other.launchType) return false
        if (loadBalancers != other.loadBalancers) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pendingCount != other.pendingCount) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategy != other.placementStrategy) return false
        if (platformFamily != other.platformFamily) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (roleArn != other.roleArn) return false
        if (runningCount != other.runningCount) return false
        if (schedulingStrategy != other.schedulingStrategy) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceName != other.serviceName) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false
        if (taskSets != other.taskSets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Service = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted if the service was created using a launch type.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster that hosts the service.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the service was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The principal that created the service.
         */
        public var createdBy: kotlin.String? = null
        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = null
        /**
         * The deployment controller type the service is using.
         */
        public var deploymentController: aws.sdk.kotlin.services.ecs.model.DeploymentController? = null
        /**
         * The current state of deployments for the service.
         */
        public var deployments: List<Deployment>? = null
        /**
         * The desired number of instantiations of the task definition to keep running on the service. This value is specified when the service is created with CreateService, and it can be modified with UpdateService.
         */
        public var desiredCount: kotlin.Int = 0
        /**
         * Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var enableEcsManagedTags: kotlin.Boolean = false
        /**
         * Determines whether the execute command functionality is turned on for the service. If `true`, the execute command functionality is turned on for all containers in tasks as part of the service.
         */
        public var enableExecuteCommand: kotlin.Boolean = false
        /**
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         */
        public var events: List<ServiceEvent>? = null
        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         */
        public var healthCheckGracePeriodSeconds: kotlin.Int? = null
        /**
         * The launch type the service is using. When using the DescribeServices API, this field is omitted if the service was created using a capacity provider strategy.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.
         */
        public var loadBalancers: List<LoadBalancer>? = null
        /**
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * The number of tasks in the cluster that are in the `PENDING` state.
         */
        public var pendingCount: kotlin.Int = 0
        /**
         * The placement constraints for the tasks in the service.
         */
        public var placementConstraints: List<PlacementConstraint>? = null
        /**
         * The placement strategy that determines how tasks for the service are placed.
         */
        public var placementStrategy: List<PlacementStrategy>? = null
        /**
         * The operating system that your tasks in the service run on. A platform family is specified only for tasks using the Fargate launch type.
         *
         *  All tasks that run as part of this service must use the same `platformFamily` value as the service (for example, `LINUX`).
         */
        public var platformFamily: kotlin.String? = null
        /**
         * The platform version to run your service on. A platform version is only specified for tasks that are hosted on Fargate. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The number of tasks in the cluster that are in the `RUNNING` state.
         */
        public var runningCount: kotlin.Int = 0
        /**
         * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
         *
         * There are two service scheduler strategies available.
         * + `REPLICA`-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions.
         * + `DAEMON`-The daemon scheduling strategy deploys exactly one task on each active container instance. This task meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the placement constraints.Fargate tasks don't support the `DAEMON` scheduling strategy.
         */
        public var schedulingStrategy: aws.sdk.kotlin.services.ecs.model.SchedulingStrategy? = null
        /**
         * The ARN that identifies the service. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster. However, you can have similarly named services in multiple clusters within a Region or across multiple Regions.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The details for the service discovery registries to assign to this service. For more information, see [Service Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
         */
        public var serviceRegistries: List<ServiceRegistry>? = null
        /**
         * The status of the service. The valid values are `ACTIVE`, `DRAINING`, or `INACTIVE`.
         */
        public var status: kotlin.String? = null
        /**
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value. You define bot the key and value.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The task definition to use for tasks in the service. This value is specified when the service is created with CreateService, and it can be modified with UpdateService.
         */
        public var taskDefinition: kotlin.String? = null
        /**
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an `EXTERNAL` deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.
         */
        public var taskSets: List<TaskSet>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Service) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.clusterArn = x.clusterArn
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.deploymentConfiguration = x.deploymentConfiguration
            this.deploymentController = x.deploymentController
            this.deployments = x.deployments
            this.desiredCount = x.desiredCount
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.events = x.events
            this.healthCheckGracePeriodSeconds = x.healthCheckGracePeriodSeconds
            this.launchType = x.launchType
            this.loadBalancers = x.loadBalancers
            this.networkConfiguration = x.networkConfiguration
            this.pendingCount = x.pendingCount
            this.placementConstraints = x.placementConstraints
            this.placementStrategy = x.placementStrategy
            this.platformFamily = x.platformFamily
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.roleArn = x.roleArn
            this.runningCount = x.runningCount
            this.schedulingStrategy = x.schedulingStrategy
            this.serviceArn = x.serviceArn
            this.serviceName = x.serviceName
            this.serviceRegistries = x.serviceRegistries
            this.status = x.status
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
            this.taskSets = x.taskSets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Service = Service(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentController] inside the given [block]
         */
        public fun deploymentController(block: aws.sdk.kotlin.services.ecs.model.DeploymentController.Builder.() -> kotlin.Unit) {
            this.deploymentController = aws.sdk.kotlin.services.ecs.model.DeploymentController.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }
    }
}
