// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * A list of namespaced kernel parameters to set in the container. This parameter maps to `Sysctls` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--sysctl` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration).
 *
 * We don't recommend that you specify network-related `systemControls` parameters for multiple containers in a single task. This task also uses either the `awsvpc` or `host` network mode. It does it for the following reasons.
 * + For tasks that use the `awsvpc` network mode, if you set `systemControls` for any container, it applies to all containers in the task. If you set different `systemControls` for multiple containers in a single task, the container that's started last determines which `systemControls` take effect.
 * + For tasks that use the `host` network mode, the `systemControls` parameter applies to the container instance's kernel parameter and that of all containers of any tasks running on that container instance.
 */
public class SystemControl private constructor(builder: Builder) {
    /**
     * The namespaced kernel parameter to set a `value` for.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The value for the namespaced kernel parameter that's specified in `namespace`.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.SystemControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SystemControl(")
        append("namespace=$namespace,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SystemControl

        if (namespace != other.namespace) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.SystemControl = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The namespaced kernel parameter to set a `value` for.
         */
        public var namespace: kotlin.String? = null
        /**
         * The value for the namespaced kernel parameter that's specified in `namespace`.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.SystemControl) : this() {
            this.namespace = x.namespace
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.SystemControl = SystemControl(this)
    }
}
