// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class UpdateTaskProtectionRequest private constructor(builder: Builder) {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * If you set `protectionEnabled` to `true`, you can specify the duration for task protection in minutes. You can specify a value from 1 minute to up to 2,880 minutes (48 hours). During this time, your task will not be terminated by scale-in events from Service Auto Scaling or deployments. After this time period lapses, `protectionEnabled` will be reset to `false`.
     *
     * If you don’t specify the time, then the task is automatically protected for 120 minutes (2 hours).
     */
    public val expiresInMinutes: kotlin.Int? = builder.expiresInMinutes
    /**
     * Specify `true` to mark a task for protection and `false` to unset protection, making it eligible for termination.
     */
    public val protectionEnabled: kotlin.Boolean = builder.protectionEnabled
    /**
     * A list of up to 10 task IDs or full ARN entries.
     */
    public val tasks: List<String>? = builder.tasks

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTaskProtectionRequest(")
        append("cluster=$cluster,")
        append("expiresInMinutes=$expiresInMinutes,")
        append("protectionEnabled=$protectionEnabled,")
        append("tasks=$tasks")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (expiresInMinutes ?: 0)
        result = 31 * result + (protectionEnabled.hashCode())
        result = 31 * result + (tasks?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTaskProtectionRequest

        if (cluster != other.cluster) return false
        if (expiresInMinutes != other.expiresInMinutes) return false
        if (protectionEnabled != other.protectionEnabled) return false
        if (tasks != other.tasks) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.
         */
        public var cluster: kotlin.String? = null
        /**
         * If you set `protectionEnabled` to `true`, you can specify the duration for task protection in minutes. You can specify a value from 1 minute to up to 2,880 minutes (48 hours). During this time, your task will not be terminated by scale-in events from Service Auto Scaling or deployments. After this time period lapses, `protectionEnabled` will be reset to `false`.
         *
         * If you don’t specify the time, then the task is automatically protected for 120 minutes (2 hours).
         */
        public var expiresInMinutes: kotlin.Int? = null
        /**
         * Specify `true` to mark a task for protection and `false` to unset protection, making it eligible for termination.
         */
        public var protectionEnabled: kotlin.Boolean = false
        /**
         * A list of up to 10 task IDs or full ARN entries.
         */
        public var tasks: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionRequest) : this() {
            this.cluster = x.cluster
            this.expiresInMinutes = x.expiresInMinutes
            this.protectionEnabled = x.protectionEnabled
            this.tasks = x.tasks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionRequest = UpdateTaskProtectionRequest(this)
    }
}
