// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * A data volume that's used in a task definition. For tasks that use the Amazon Elastic File System (Amazon EFS), specify an `efsVolumeConfiguration`. For Windows tasks that use Amazon FSx for Windows File Server file system, specify a `fsxWindowsFileServerVolumeConfiguration`. For tasks that use a Docker volume, specify a `DockerVolumeConfiguration`. For tasks that use a bind mount host volume, specify a `host` and optional `sourcePath`. For more information, see [Using Data Volumes in Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
 */
public class Volume private constructor(builder: Builder) {
    /**
     * This parameter is specified when you use Docker volumes.
     *
     * Windows containers only support the use of the `local` driver. To use bind mounts, specify the `host` parameter instead.
     *
     * Docker volumes aren't supported by tasks run on Fargate.
     */
    public val dockerVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration? = builder.dockerVolumeConfiguration
    /**
     * This parameter is specified when you use an Amazon Elastic File System file system for task storage.
     */
    public val efsVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.EfsVolumeConfiguration? = builder.efsVolumeConfiguration
    /**
     * This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
     */
    public val fsxWindowsFileServerVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration? = builder.fsxWindowsFileServerVolumeConfiguration
    /**
     * This parameter is specified when you use bind mount host volumes. The contents of the `host` parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the `host` parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
     *
     * Windows containers can mount whole directories on the same drive as `$env:ProgramData`. Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount `C:\my\path:C:\my\path` and `D:\:D:\`, but not `D:\my\path:C:\my\path` or `D:\:C:\my\path`.
     */
    public val host: aws.sdk.kotlin.services.ecs.model.HostVolumeProperties? = builder.host
    /**
     * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the `sourceVolume` parameter of container definition `mountPoints`.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Volume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("dockerVolumeConfiguration=$dockerVolumeConfiguration,")
        append("efsVolumeConfiguration=$efsVolumeConfiguration,")
        append("fsxWindowsFileServerVolumeConfiguration=$fsxWindowsFileServerVolumeConfiguration,")
        append("host=$host,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dockerVolumeConfiguration?.hashCode() ?: 0
        result = 31 * result + (efsVolumeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fsxWindowsFileServerVolumeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (host?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Volume

        if (dockerVolumeConfiguration != other.dockerVolumeConfiguration) return false
        if (efsVolumeConfiguration != other.efsVolumeConfiguration) return false
        if (fsxWindowsFileServerVolumeConfiguration != other.fsxWindowsFileServerVolumeConfiguration) return false
        if (host != other.host) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Volume = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This parameter is specified when you use Docker volumes.
         *
         * Windows containers only support the use of the `local` driver. To use bind mounts, specify the `host` parameter instead.
         *
         * Docker volumes aren't supported by tasks run on Fargate.
         */
        public var dockerVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration? = null
        /**
         * This parameter is specified when you use an Amazon Elastic File System file system for task storage.
         */
        public var efsVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.EfsVolumeConfiguration? = null
        /**
         * This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
         */
        public var fsxWindowsFileServerVolumeConfiguration: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration? = null
        /**
         * This parameter is specified when you use bind mount host volumes. The contents of the `host` parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the `host` parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
         *
         * Windows containers can mount whole directories on the same drive as `$env:ProgramData`. Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount `C:\my\path:C:\my\path` and `D:\:D:\`, but not `D:\my\path:C:\my\path` or `D:\:C:\my\path`.
         */
        public var host: aws.sdk.kotlin.services.ecs.model.HostVolumeProperties? = null
        /**
         * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the `sourceVolume` parameter of container definition `mountPoints`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Volume) : this() {
            this.dockerVolumeConfiguration = x.dockerVolumeConfiguration
            this.efsVolumeConfiguration = x.efsVolumeConfiguration
            this.fsxWindowsFileServerVolumeConfiguration = x.fsxWindowsFileServerVolumeConfiguration
            this.host = x.host
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Volume = Volume(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration] inside the given [block]
         */
        public fun dockerVolumeConfiguration(block: aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.dockerVolumeConfiguration = aws.sdk.kotlin.services.ecs.model.DockerVolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.EfsVolumeConfiguration] inside the given [block]
         */
        public fun efsVolumeConfiguration(block: aws.sdk.kotlin.services.ecs.model.EfsVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.efsVolumeConfiguration = aws.sdk.kotlin.services.ecs.model.EfsVolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration] inside the given [block]
         */
        public fun fsxWindowsFileServerVolumeConfiguration(block: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.fsxWindowsFileServerVolumeConfiguration = aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.HostVolumeProperties] inside the given [block]
         */
        public fun host(block: aws.sdk.kotlin.services.ecs.model.HostVolumeProperties.Builder.() -> kotlin.Unit) {
            this.host = aws.sdk.kotlin.services.ecs.model.HostVolumeProperties.invoke(block)
        }
    }
}
