// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.transform

import aws.sdk.kotlin.services.ecs.model.EcsException
import aws.sdk.kotlin.services.ecs.model.PutAccountSettingResponse
import aws.sdk.kotlin.services.ecs.model.Setting
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutAccountSettingOperationDeserializer: HttpDeserialize<PutAccountSettingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutAccountSettingResponse {
        if (!response.status.isSuccess()) {
            throwPutAccountSettingError(context, response)
        }
        val builder = PutAccountSettingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutAccountSettingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutAccountSettingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EcsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EcsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutAccountSettingOperationBody(builder: PutAccountSettingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("setting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SETTING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SETTING_DESCRIPTOR.index -> builder.setting = deserializeSettingDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
