// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.waiters

import aws.sdk.kotlin.services.ecs.EcsClient
import aws.sdk.kotlin.services.ecs.model.DescribeServicesRequest
import aws.sdk.kotlin.services.ecs.model.DescribeServicesResponse
import aws.sdk.kotlin.services.ecs.model.DescribeTasksRequest
import aws.sdk.kotlin.services.ecs.model.DescribeTasksResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import aws.smithy.kotlin.runtime.util.truthiness
import kotlin.time.Duration.Companion.milliseconds


public suspend fun EcsClient.waitUntilServicesInactive(request: DescribeServicesRequest): Outcome<DescribeServicesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeServicesRequest, DescribeServicesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val failures = it.failures
            val failuresOrEmpty = failures?.flattenIfPossible()
            val projection = failuresOrEmpty?.flatMap {
                val reason = it.reason
                listOfNotNull(reason)
            }
            projection?.any { it == "MISSING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val services = it.services
            val servicesOrEmpty = services?.flattenIfPossible()
            val projection = servicesOrEmpty?.flatMap {
                val status = it.status
                listOfNotNull(status)
            }
            projection?.any { it == "INACTIVE" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeServices(request) }
}

public suspend fun EcsClient.waitUntilServicesInactive(block: DescribeServicesRequest.Builder.() -> Unit): Outcome<DescribeServicesResponse> =
    waitUntilServicesInactive(DescribeServicesRequest.Builder().apply(block).build())

public suspend fun EcsClient.waitUntilServicesStable(request: DescribeServicesRequest): Outcome<DescribeServicesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeServicesRequest, DescribeServicesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val failures = it.failures
            val failuresOrEmpty = failures?.flattenIfPossible()
            val projection = failuresOrEmpty?.flatMap {
                val reason = it.reason
                listOfNotNull(reason)
            }
            projection?.any { it == "MISSING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val services = it.services
            val servicesOrEmpty = services?.flattenIfPossible()
            val projection = servicesOrEmpty?.flatMap {
                val status = it.status
                listOfNotNull(status)
            }
            projection?.any { it == "DRAINING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val services = it.services
            val servicesOrEmpty = services?.flattenIfPossible()
            val projection = servicesOrEmpty?.flatMap {
                val status = it.status
                listOfNotNull(status)
            }
            projection?.any { it == "INACTIVE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val services = it.services
            val servicesFiltered = services?.filter {
                val deployments = it.deployments
                val length = deployments?.length ?: 0
                val number = 1.0
                val comparison = length.compareTo(number) == 0
                val comparisonTruthiness = truthiness(comparison)
                val runningCount = it.runningCount
                val desiredCount = it.desiredCount
                val comparison2 = runningCount.compareTo(desiredCount) == 0
                val and = if (comparisonTruthiness) comparison2 else comparison
                val andTruthiness = truthiness(and)
                val notAnd = !andTruthiness
                notAnd == true
            }
            val length2 = servicesFiltered?.length ?: 0
            val number2 = 0.0
            val comparison3 = length2.compareTo(number2) == 0
            comparison3 == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeServices(request) }
}

public suspend fun EcsClient.waitUntilServicesStable(block: DescribeServicesRequest.Builder.() -> Unit): Outcome<DescribeServicesResponse> =
    waitUntilServicesStable(DescribeServicesRequest.Builder().apply(block).build())

public suspend fun EcsClient.waitUntilTasksRunning(request: DescribeTasksRequest): Outcome<DescribeTasksResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 6_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTasksRequest, DescribeTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val tasks = it.tasks
            val tasksOrEmpty = tasks?.flattenIfPossible()
            val projection = tasksOrEmpty?.flatMap {
                val lastStatus = it.lastStatus
                listOfNotNull(lastStatus)
            }
            projection?.any { it == "STOPPED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val failures = it.failures
            val failuresOrEmpty = failures?.flattenIfPossible()
            val projection = failuresOrEmpty?.flatMap {
                val reason = it.reason
                listOfNotNull(reason)
            }
            projection?.any { it == "MISSING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val tasks = it.tasks
            val tasksOrEmpty = tasks?.flattenIfPossible()
            val projection = tasksOrEmpty?.flatMap {
                val lastStatus = it.lastStatus
                listOfNotNull(lastStatus)
            }
            !projection.isNullOrEmpty() && projection.all { it == "RUNNING" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTasks(request) }
}

public suspend fun EcsClient.waitUntilTasksRunning(block: DescribeTasksRequest.Builder.() -> Unit): Outcome<DescribeTasksResponse> =
    waitUntilTasksRunning(DescribeTasksRequest.Builder().apply(block).build())

public suspend fun EcsClient.waitUntilTasksStopped(request: DescribeTasksRequest): Outcome<DescribeTasksResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 6_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTasksRequest, DescribeTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val tasks = it.tasks
            val tasksOrEmpty = tasks?.flattenIfPossible()
            val projection = tasksOrEmpty?.flatMap {
                val lastStatus = it.lastStatus
                listOfNotNull(lastStatus)
            }
            !projection.isNullOrEmpty() && projection.all { it == "STOPPED" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTasks(request) }
}

public suspend fun EcsClient.waitUntilTasksStopped(block: DescribeTasksRequest.Builder.() -> Unit): Outcome<DescribeTasksResponse> =
    waitUntilTasksStopped(DescribeTasksRequest.Builder().apply(block).build())
