// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.paginators

import aws.sdk.kotlin.services.iotsecuretunneling.IotSecureTunnelingClient
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTunnelsRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTunnelsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListTunnelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTunnelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTunnelsResponse]
 */
public fun IotSecureTunnelingClient.listTunnelsPaginated(initialRequest: ListTunnelsRequest = ListTunnelsRequest { }): Flow<ListTunnelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTunnelsPaginated.listTunnels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTunnelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTunnelsResponse]
 */
public fun IotSecureTunnelingClient.listTunnelsPaginated(block: ListTunnelsRequest.Builder.() -> Unit): Flow<ListTunnelsResponse> =
    listTunnelsPaginated(ListTunnelsRequest.Builder().apply(block).build())
