// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.serde

import aws.sdk.kotlin.services.iotsecuretunneling.model.IotSecureTunnelingException
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTunnelsResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.TunnelSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListTunnelsOperationDeserializer: HttpDeserializer.NonStreaming<ListTunnelsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTunnelsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTunnelsError(context, call, payload)
        }
        val builder = ListTunnelsResponse.Builder()

        if (payload != null) {
            deserializeListTunnelsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTunnelsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSecureTunnelingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> IotSecureTunnelingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTunnelsOperationBody(builder: ListTunnelsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val TUNNELSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tunnelSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(TUNNELSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TUNNELSUMMARIES_DESCRIPTOR.index -> builder.tunnelSummaries =
                    deserializer.deserializeList(TUNNELSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<TunnelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTunnelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
