// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.serde

import aws.sdk.kotlin.services.iotsecuretunneling.model.IotSecureTunnelingException
import aws.sdk.kotlin.services.iotsecuretunneling.model.OpenTunnelResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class OpenTunnelOperationDeserializer: HttpDeserializer.NonStreaming<OpenTunnelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): OpenTunnelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwOpenTunnelError(context, call, payload)
        }
        val builder = OpenTunnelResponse.Builder()

        if (payload != null) {
            deserializeOpenTunnelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwOpenTunnelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSecureTunnelingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSecureTunnelingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeOpenTunnelOperationBody(builder: OpenTunnelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationAccessToken"))
    val SOURCEACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceAccessToken"))
    val TUNNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tunnelArn"))
    val TUNNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tunnelId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONACCESSTOKEN_DESCRIPTOR)
        field(SOURCEACCESSTOKEN_DESCRIPTOR)
        field(TUNNELARN_DESCRIPTOR)
        field(TUNNELID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONACCESSTOKEN_DESCRIPTOR.index -> builder.destinationAccessToken = deserializeString()
                SOURCEACCESSTOKEN_DESCRIPTOR.index -> builder.sourceAccessToken = deserializeString()
                TUNNELARN_DESCRIPTOR.index -> builder.tunnelArn = deserializeString()
                TUNNELID_DESCRIPTOR.index -> builder.tunnelId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
