// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "route53.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-global" to EndpointDefinition(
                hostname = "route53.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "fips-aws-global" to EndpointDefinition(
                hostname = "route53-fips.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-cn-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "route53.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-cn-global" to EndpointDefinition(
                hostname = "route53.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-northwest-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-iso-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "route53.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-iso-global" to EndpointDefinition(
                hostname = "route53.c2s.ic.gov",
                credentialScope = CredentialScope(region = "us-iso-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-iso-b-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "route53.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-iso-b-global" to EndpointDefinition(
                hostname = "route53.sc2s.sgov.gov",
                credentialScope = CredentialScope(region = "us-isob-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-us-gov-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "route53.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-us-gov-global" to EndpointDefinition(
                hostname = "route53.us-gov.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "fips-aws-us-gov-global" to EndpointDefinition(
                hostname = "route53.us-gov.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
        )
    ),
)
