// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the type of limit that you specified in the request and the current value for that limit.
 */
class AccountLimit private constructor(builder: Builder) {
    /**
     * The limit that you requested. Valid values include the following:
     * + **MAX_HEALTH_CHECKS_BY_OWNER**: The maximum number of health checks that you can create using the current account.
     * + **MAX_HOSTED_ZONES_BY_OWNER**: The maximum number of hosted zones that you can create using the current account.
     * + **MAX_REUSABLE_DELEGATION_SETS_BY_OWNER**: The maximum number of reusable delegation sets that you can create using the current account.
     * + **MAX_TRAFFIC_POLICIES_BY_OWNER**: The maximum number of traffic policies that you can create using the current account.
     * + **MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER**: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)
     */
    val type: aws.sdk.kotlin.services.route53.model.AccountLimitType? = builder.type
    /**
     * The current value for the limit that is specified by [Type](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AccountLimit.html#Route53-Type-AccountLimit-Type).
     */
    val value: kotlin.Long = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.AccountLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountLimit(")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountLimit

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.AccountLimit = Builder(this).apply(block).build()

    class Builder {
        /**
         * The limit that you requested. Valid values include the following:
         * + **MAX_HEALTH_CHECKS_BY_OWNER**: The maximum number of health checks that you can create using the current account.
         * + **MAX_HOSTED_ZONES_BY_OWNER**: The maximum number of hosted zones that you can create using the current account.
         * + **MAX_REUSABLE_DELEGATION_SETS_BY_OWNER**: The maximum number of reusable delegation sets that you can create using the current account.
         * + **MAX_TRAFFIC_POLICIES_BY_OWNER**: The maximum number of traffic policies that you can create using the current account.
         * + **MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER**: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)
         */
        var type: aws.sdk.kotlin.services.route53.model.AccountLimitType? = null
        /**
         * The current value for the limit that is specified by [Type](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AccountLimit.html#Route53-Type-AccountLimit-Type).
         */
        var value: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.AccountLimit) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.AccountLimit = AccountLimit(this)
    }
}
