// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
 */
class AlarmIdentifier private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
     *
     * Route 53 supports CloudWatch alarms with the following features:
     * + Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide*.
     * + Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.
     */
    val name: kotlin.String? = builder.name
    /**
     * For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
     *
     * For the current list of CloudWatch regions, see [Amazon CloudWatch endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/cw_region.html) in the *Amazon Web Services General Reference*.
     */
    val region: aws.sdk.kotlin.services.route53.model.CloudWatchRegion? = builder.region

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.AlarmIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmIdentifier(")
        append("name=$name,")
        append("region=$region)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmIdentifier

        if (name != other.name) return false
        if (region != other.region) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.AlarmIdentifier = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
         *
         * Route 53 supports CloudWatch alarms with the following features:
         * + Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide*.
         * + Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.
         */
        var name: kotlin.String? = null
        /**
         * For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
         *
         * For the current list of CloudWatch regions, see [Amazon CloudWatch endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/cw_region.html) in the *Amazon Web Services General Reference*.
         */
        var region: aws.sdk.kotlin.services.route53.model.CloudWatchRegion? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.AlarmIdentifier) : this() {
            this.name = x.name
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.AlarmIdentifier = AlarmIdentifier(this)
    }
}
