// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * The information for each resource record set that you want to change.
 */
class Change private constructor(builder: Builder) {
    /**
     * The action to perform:
     * + `CREATE`: Creates a resource record set that has the specified values.
     * + `DELETE`: Deletes a existing resource record set.To delete the resource record set that is associated with a traffic policy instance, use [DeleteTrafficPolicyInstance](https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html). Amazon Route 53 will delete the resource record set automatically. If you delete the resource record set by using `ChangeResourceRecordSets`, Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in use.
     * + `UPSERT`: If a resource record set doesn't already exist, Route 53 creates it. If a resource record set does exist, Route 53 updates it with the values in the request.
     */
    val action: aws.sdk.kotlin.services.route53.model.ChangeAction? = builder.action
    /**
     * Information about the resource record set to create, delete, or update.
     */
    val resourceRecordSet: aws.sdk.kotlin.services.route53.model.ResourceRecordSet? = builder.resourceRecordSet

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.Change = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Change(")
        append("action=$action,")
        append("resourceRecordSet=$resourceRecordSet)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (resourceRecordSet?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Change

        if (action != other.action) return false
        if (resourceRecordSet != other.resourceRecordSet) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.Change = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action to perform:
         * + `CREATE`: Creates a resource record set that has the specified values.
         * + `DELETE`: Deletes a existing resource record set.To delete the resource record set that is associated with a traffic policy instance, use [DeleteTrafficPolicyInstance](https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html). Amazon Route 53 will delete the resource record set automatically. If you delete the resource record set by using `ChangeResourceRecordSets`, Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in use.
         * + `UPSERT`: If a resource record set doesn't already exist, Route 53 creates it. If a resource record set does exist, Route 53 updates it with the values in the request.
         */
        var action: aws.sdk.kotlin.services.route53.model.ChangeAction? = null
        /**
         * Information about the resource record set to create, delete, or update.
         */
        var resourceRecordSet: aws.sdk.kotlin.services.route53.model.ResourceRecordSet? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.Change) : this() {
            this.action = x.action
            this.resourceRecordSet = x.resourceRecordSet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.Change = Change(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.ResourceRecordSet] inside the given [block]
         */
        fun resourceRecordSet(block: aws.sdk.kotlin.services.route53.model.ResourceRecordSet.Builder.() -> kotlin.Unit) {
            this.resourceRecordSet = aws.sdk.kotlin.services.route53.model.ResourceRecordSet.invoke(block)
        }
    }
}
