// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



class ChangeCidrCollectionRequest private constructor(builder: Builder) {
    /**
     * Information about changes to a CIDR collection.
     */
    val changes: List<CidrCollectionChange>? = builder.changes
    /**
     * A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by 1 each time you update the collection.
     *
     * We recommend that you use `ListCidrCollection` to get the current value of `CollectionVersion` for the collection that you want to update, and then include that value with the change request. This prevents Route 53 from overwriting an intervening update:
     * + If the value in the request matches the value of `CollectionVersion` in the collection, Route 53 updates the collection.
     * + If the value of `CollectionVersion` in the collection is greater than the value in the request, the collection was changed after you got the version number. Route 53 does not update the collection, and it returns a `CidrCollectionVersionMismatch` error.
     */
    val collectionVersion: kotlin.Long? = builder.collectionVersion
    /**
     * The UUID of the CIDR collection to update.
     */
    val id: kotlin.String? = requireNotNull(builder.id) { "A non-null value must be provided for id" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ChangeCidrCollectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeCidrCollectionRequest(")
        append("changes=$changes,")
        append("collectionVersion=$collectionVersion,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changes?.hashCode() ?: 0
        result = 31 * result + (collectionVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeCidrCollectionRequest

        if (changes != other.changes) return false
        if (collectionVersion != other.collectionVersion) return false
        if (id != other.id) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ChangeCidrCollectionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about changes to a CIDR collection.
         */
        var changes: List<CidrCollectionChange>? = null
        /**
         * A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by 1 each time you update the collection.
         *
         * We recommend that you use `ListCidrCollection` to get the current value of `CollectionVersion` for the collection that you want to update, and then include that value with the change request. This prevents Route 53 from overwriting an intervening update:
         * + If the value in the request matches the value of `CollectionVersion` in the collection, Route 53 updates the collection.
         * + If the value of `CollectionVersion` in the collection is greater than the value in the request, the collection was changed after you got the version number. Route 53 does not update the collection, and it returns a `CidrCollectionVersionMismatch` error.
         */
        var collectionVersion: kotlin.Long? = null
        /**
         * The UUID of the CIDR collection to update.
         */
        var id: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ChangeCidrCollectionRequest) : this() {
            this.changes = x.changes
            this.collectionVersion = x.collectionVersion
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ChangeCidrCollectionRequest = ChangeCidrCollectionRequest(this)
    }
}
