// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the tags that you want to add, edit, or delete.
 */
class ChangeTagsForResourceRequest private constructor(builder: Builder) {
    /**
     * A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit `Value` for.
     *
     * You can add a maximum of 10 tags to a health check or a hosted zone.
     */
    val addTags: List<Tag>? = builder.addTags
    /**
     * A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.
     */
    val removeTagKeys: List<String>? = builder.removeTagKeys
    /**
     * The ID of the resource for which you want to add, change, or delete tags.
     */
    val resourceId: kotlin.String? = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The type of the resource.
     * + The resource type for health checks is `healthcheck`.
     * + The resource type for hosted zones is `hostedzone`.
     */
    val resourceType: aws.sdk.kotlin.services.route53.model.TagResourceType? = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ChangeTagsForResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeTagsForResourceRequest(")
        append("addTags=$addTags,")
        append("removeTagKeys=$removeTagKeys,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addTags?.hashCode() ?: 0
        result = 31 * result + (removeTagKeys?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeTagsForResourceRequest

        if (addTags != other.addTags) return false
        if (removeTagKeys != other.removeTagKeys) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ChangeTagsForResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit `Value` for.
         *
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         */
        var addTags: List<Tag>? = null
        /**
         * A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.
         */
        var removeTagKeys: List<String>? = null
        /**
         * The ID of the resource for which you want to add, change, or delete tags.
         */
        var resourceId: kotlin.String? = null
        /**
         * The type of the resource.
         * + The resource type for health checks is `healthcheck`.
         * + The resource type for hosted zones is `hostedzone`.
         */
        var resourceType: aws.sdk.kotlin.services.route53.model.TagResourceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ChangeTagsForResourceRequest) : this() {
            this.addTags = x.addTags
            this.removeTagKeys = x.removeTagKeys
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ChangeTagsForResourceRequest = ChangeTagsForResourceRequest(this)
    }
}
