// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this health check.
 */
class CloudWatchAlarmConfiguration private constructor(builder: Builder) {
    /**
     * For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the comparison.
     */
    val comparisonOperator: aws.sdk.kotlin.services.route53.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * For the metric that the CloudWatch alarm is associated with, a complex type that contains information about the dimensions for the metric. For information, see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
     */
    val dimensions: List<Dimension>? = builder.dimensions
    /**
     * For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is compared to the threshold.
     */
    val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * The name of the CloudWatch metric that the alarm is associated with.
     */
    val metricName: kotlin.String? = builder.metricName
    /**
     * The namespace of the metric that the alarm is associated with. For more information, see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
     */
    val namespace: kotlin.String? = builder.namespace
    /**
     * For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in seconds.
     */
    val period: kotlin.Int? = builder.period
    /**
     * For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
     */
    val statistic: aws.sdk.kotlin.services.route53.model.Statistic? = builder.statistic
    /**
     * For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
     */
    val threshold: kotlin.Double? = builder.threshold

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchAlarmConfiguration(")
        append("comparisonOperator=$comparisonOperator,")
        append("dimensions=$dimensions,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("period=$period,")
        append("statistic=$statistic,")
        append("threshold=$threshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchAlarmConfiguration

        if (comparisonOperator != other.comparisonOperator) return false
        if (dimensions != other.dimensions) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (period != other.period) return false
        if (statistic != other.statistic) return false
        if (threshold != other.threshold) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the comparison.
         */
        var comparisonOperator: aws.sdk.kotlin.services.route53.model.ComparisonOperator? = null
        /**
         * For the metric that the CloudWatch alarm is associated with, a complex type that contains information about the dimensions for the metric. For information, see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
         */
        var dimensions: List<Dimension>? = null
        /**
         * For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is compared to the threshold.
         */
        var evaluationPeriods: kotlin.Int? = null
        /**
         * The name of the CloudWatch metric that the alarm is associated with.
         */
        var metricName: kotlin.String? = null
        /**
         * The namespace of the metric that the alarm is associated with. For more information, see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
         */
        var namespace: kotlin.String? = null
        /**
         * For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in seconds.
         */
        var period: kotlin.Int? = null
        /**
         * For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
         */
        var statistic: aws.sdk.kotlin.services.route53.model.Statistic? = null
        /**
         * For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
         */
        var threshold: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.dimensions = x.dimensions
            this.evaluationPeriods = x.evaluationPeriods
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.period = x.period
            this.statistic = x.statistic
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration = CloudWatchAlarmConfiguration(this)
    }
}
