// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that is an entry in an [CidrCollection](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CidrCollection.html) array.
 */
class CollectionSummary private constructor(builder: Builder) {
    /**
     * The ARN of the collection summary. Can be used to reference the collection in IAM policy or cross-account.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Unique ID for the CIDR collection.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of a CIDR collection.
     */
    val name: kotlin.String? = builder.name
    /**
     * A sequential counter that Route 53 sets to 1 when you create a CIDR collection and increments by 1 each time you update settings for the CIDR collection.
     */
    val version: kotlin.Long? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CollectionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollectionSummary(")
        append("arn=$arn,")
        append("id=$id,")
        append("name=$name,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollectionSummary

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CollectionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the collection summary. Can be used to reference the collection in IAM policy or cross-account.
         */
        var arn: kotlin.String? = null
        /**
         * Unique ID for the CIDR collection.
         */
        var id: kotlin.String? = null
        /**
         * The name of a CIDR collection.
         */
        var name: kotlin.String? = null
        /**
         * A sequential counter that Route 53 sets to 1 when you create a CIDR collection and increments by 1 each time you update settings for the CIDR collection.
         */
        var version: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CollectionSummary) : this() {
            this.arn = x.arn
            this.id = x.id
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CollectionSummary = CollectionSummary(this)
    }
}
