// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the health check request information.
 */
class CreateHealthCheckRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows you to retry a failed `CreateHealthCheck` request without the risk of creating two identical health checks:
     * + If you send a `CreateHealthCheck` request with the same `CallerReference` and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.
     * + If you send a `CreateHealthCheck` request with the same `CallerReference` as a deleted health check, regardless of the settings, Route 53 returns a `HealthCheckAlreadyExists` error.
     * + If you send a `CreateHealthCheck` request with the same `CallerReference` as an existing health check but with different settings, Route 53 returns a `HealthCheckAlreadyExists` error.
     * + If you send a `CreateHealthCheck` request with a unique `CallerReference` but settings identical to an existing health check, Route 53 creates the health check.
     */
    val callerReference: kotlin.String? = builder.callerReference
    /**
     * A complex type that contains settings for a new health check.
     */
    val healthCheckConfig: aws.sdk.kotlin.services.route53.model.HealthCheckConfig? = builder.healthCheckConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CreateHealthCheckRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHealthCheckRequest(")
        append("callerReference=$callerReference,")
        append("healthCheckConfig=$healthCheckConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (healthCheckConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHealthCheckRequest

        if (callerReference != other.callerReference) return false
        if (healthCheckConfig != other.healthCheckConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CreateHealthCheckRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that identifies the request and that allows you to retry a failed `CreateHealthCheck` request without the risk of creating two identical health checks:
         * + If you send a `CreateHealthCheck` request with the same `CallerReference` and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.
         * + If you send a `CreateHealthCheck` request with the same `CallerReference` as a deleted health check, regardless of the settings, Route 53 returns a `HealthCheckAlreadyExists` error.
         * + If you send a `CreateHealthCheck` request with the same `CallerReference` as an existing health check but with different settings, Route 53 returns a `HealthCheckAlreadyExists` error.
         * + If you send a `CreateHealthCheck` request with a unique `CallerReference` but settings identical to an existing health check, Route 53 creates the health check.
         */
        var callerReference: kotlin.String? = null
        /**
         * A complex type that contains settings for a new health check.
         */
        var healthCheckConfig: aws.sdk.kotlin.services.route53.model.HealthCheckConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CreateHealthCheckRequest) : this() {
            this.callerReference = x.callerReference
            this.healthCheckConfig = x.healthCheckConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CreateHealthCheckRequest = CreateHealthCheckRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.HealthCheckConfig] inside the given [block]
         */
        fun healthCheckConfig(block: aws.sdk.kotlin.services.route53.model.HealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckConfig = aws.sdk.kotlin.services.route53.model.HealthCheckConfig.invoke(block)
        }
    }
}
