// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the request to create a public or private hosted zone.
 */
class CreateHostedZoneRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed `CreateHostedZone` requests to be retried without the risk of executing the operation twice. You must use a unique `CallerReference` string every time you submit a `CreateHostedZone` request. `CallerReference` can be any unique string, for example, a date/time stamp.
     */
    val callerReference: kotlin.String? = builder.callerReference
    /**
     * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see [CreateReusableDelegationSet](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
     */
    val delegationSetId: kotlin.String? = builder.delegationSetId
    /**
     * (Optional) A complex type that contains the following optional values:
     * + For public and private hosted zones, an optional comment
     * + For private hosted zones, an optional `PrivateZone` element
     *
     * If you don't specify a comment or the `PrivateZone` element, omit `HostedZoneConfig` and the other elements.
     */
    val hostedZoneConfig: aws.sdk.kotlin.services.route53.model.HostedZoneConfig? = builder.hostedZoneConfig
    /**
     * The name of the domain. Specify a fully qualified domain name, for example, *www.example.com*. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats *www.example.com* (without a trailing dot) and *www.example.com.* (with a trailing dot) as identical.
     *
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of `NameServers` that `CreateHostedZone` returns in `DelegationSet`.
     */
    val name: kotlin.String? = builder.name
    /**
     * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.
     *
     * You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters `VPCId` and `VPCRegion` are also required.
     *
     * To associate additional Amazon VPCs with the hosted zone, use [AssociateVPCWithHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html) after you create a hosted zone.
     */
    val vpc: aws.sdk.kotlin.services.route53.model.Vpc? = builder.vpc

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CreateHostedZoneRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHostedZoneRequest(")
        append("callerReference=$callerReference,")
        append("delegationSetId=$delegationSetId,")
        append("hostedZoneConfig=$hostedZoneConfig,")
        append("name=$name,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (delegationSetId?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHostedZoneRequest

        if (callerReference != other.callerReference) return false
        if (delegationSetId != other.delegationSetId) return false
        if (hostedZoneConfig != other.hostedZoneConfig) return false
        if (name != other.name) return false
        if (vpc != other.vpc) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CreateHostedZoneRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that identifies the request and that allows failed `CreateHostedZone` requests to be retried without the risk of executing the operation twice. You must use a unique `CallerReference` string every time you submit a `CreateHostedZone` request. `CallerReference` can be any unique string, for example, a date/time stamp.
         */
        var callerReference: kotlin.String? = null
        /**
         * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see [CreateReusableDelegationSet](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
         */
        var delegationSetId: kotlin.String? = null
        /**
         * (Optional) A complex type that contains the following optional values:
         * + For public and private hosted zones, an optional comment
         * + For private hosted zones, an optional `PrivateZone` element
         *
         * If you don't specify a comment or the `PrivateZone` element, omit `HostedZoneConfig` and the other elements.
         */
        var hostedZoneConfig: aws.sdk.kotlin.services.route53.model.HostedZoneConfig? = null
        /**
         * The name of the domain. Specify a fully qualified domain name, for example, *www.example.com*. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats *www.example.com* (without a trailing dot) and *www.example.com.* (with a trailing dot) as identical.
         *
         * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of `NameServers` that `CreateHostedZone` returns in `DelegationSet`.
         */
        var name: kotlin.String? = null
        /**
         * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.
         *
         * You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters `VPCId` and `VPCRegion` are also required.
         *
         * To associate additional Amazon VPCs with the hosted zone, use [AssociateVPCWithHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html) after you create a hosted zone.
         */
        var vpc: aws.sdk.kotlin.services.route53.model.Vpc? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CreateHostedZoneRequest) : this() {
            this.callerReference = x.callerReference
            this.delegationSetId = x.delegationSetId
            this.hostedZoneConfig = x.hostedZoneConfig
            this.name = x.name
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CreateHostedZoneRequest = CreateHostedZoneRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.HostedZoneConfig] inside the given [block]
         */
        fun hostedZoneConfig(block: aws.sdk.kotlin.services.route53.model.HostedZoneConfig.Builder.() -> kotlin.Unit) {
            this.hostedZoneConfig = aws.sdk.kotlin.services.route53.model.HostedZoneConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.Vpc] inside the given [block]
         */
        fun vpc(block: aws.sdk.kotlin.services.route53.model.Vpc.Builder.() -> kotlin.Unit) {
            this.vpc = aws.sdk.kotlin.services.route53.model.Vpc.invoke(block)
        }
    }
}
