// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



class CreateKeySigningKeyRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request.
     */
    val callerReference: kotlin.String? = builder.callerReference
    /**
     * The unique string (ID) used to identify a hosted zone.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The `KeyManagementServiceArn` must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of `KeyManagementServiceArn` that grants the correct permissions for DNSSEC, scroll down to **Example**.
     *
     * You must configure the customer managed customer managed key as follows:
     *
     * ## Status
     * Enabled
     *
     * ## Key spec
     * ECC_NIST_P256
     *
     * ## Key usage
     * Sign and verify
     *
     * ## Key policy
     * The key policy must give permission for the following actions:
     * + DescribeKey
     * + GetPublicKey
     * + Sign
     * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:
     * + `"Service": "dnssec-route53.amazonaws.com"`
     *
     * For more information about working with a customer managed key in KMS, see [Key Management Service concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
     */
    val keyManagementServiceArn: kotlin.String? = builder.keyManagementServiceArn
    /**
     * A string used to identify a key-signing key (KSK). `Name` can include numbers, letters, and underscores (_). `Name` must be unique for each key-signing key in the same hosted zone.
     */
    val name: kotlin.String? = builder.name
    /**
     * A string specifying the initial status of the key-signing key (KSK). You can set the value to `ACTIVE` or `INACTIVE`.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CreateKeySigningKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKeySigningKeyRequest(")
        append("callerReference=$callerReference,")
        append("hostedZoneId=$hostedZoneId,")
        append("keyManagementServiceArn=$keyManagementServiceArn,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (keyManagementServiceArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKeySigningKeyRequest

        if (callerReference != other.callerReference) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (keyManagementServiceArn != other.keyManagementServiceArn) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CreateKeySigningKeyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that identifies the request.
         */
        var callerReference: kotlin.String? = null
        /**
         * The unique string (ID) used to identify a hosted zone.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The `KeyManagementServiceArn` must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of `KeyManagementServiceArn` that grants the correct permissions for DNSSEC, scroll down to **Example**.
         *
         * You must configure the customer managed customer managed key as follows:
         *
         * ## Status
         * Enabled
         *
         * ## Key spec
         * ECC_NIST_P256
         *
         * ## Key usage
         * Sign and verify
         *
         * ## Key policy
         * The key policy must give permission for the following actions:
         * + DescribeKey
         * + GetPublicKey
         * + Sign
         * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:
         * + `"Service": "dnssec-route53.amazonaws.com"`
         *
         * For more information about working with a customer managed key in KMS, see [Key Management Service concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
         */
        var keyManagementServiceArn: kotlin.String? = null
        /**
         * A string used to identify a key-signing key (KSK). `Name` can include numbers, letters, and underscores (_). `Name` must be unique for each key-signing key in the same hosted zone.
         */
        var name: kotlin.String? = null
        /**
         * A string specifying the initial status of the key-signing key (KSK). You can set the value to `ACTIVE` or `INACTIVE`.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CreateKeySigningKeyRequest) : this() {
            this.callerReference = x.callerReference
            this.hostedZoneId = x.hostedZoneId
            this.keyManagementServiceArn = x.keyManagementServiceArn
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CreateKeySigningKeyRequest = CreateKeySigningKeyRequest(this)
    }
}
