// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



class CreateQueryLoggingConfigRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:
     *
     * arn:aws:logs:*region*:*account-id*:log-group:*log_group_name*
     *
     * To get the ARN for a log group, you can use the CloudWatch console, the [DescribeLogGroups](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html) API action, the [describe-log-groups](https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html) command, or the applicable command in one of the Amazon Web Services SDKs.
     */
    val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CreateQueryLoggingConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQueryLoggingConfigRequest(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("hostedZoneId=$hostedZoneId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQueryLoggingConfigRequest

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (hostedZoneId != other.hostedZoneId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CreateQueryLoggingConfigRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:
         *
         * arn:aws:logs:*region*:*account-id*:log-group:*log_group_name*
         *
         * To get the ARN for a log group, you can use the CloudWatch console, the [DescribeLogGroups](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html) API action, the [describe-log-groups](https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html) command, or the applicable command in one of the Amazon Web Services SDKs.
         */
        var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
         */
        var hostedZoneId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CreateQueryLoggingConfigRequest) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.hostedZoneId = x.hostedZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CreateQueryLoggingConfigRequest = CreateQueryLoggingConfigRequest(this)
    }
}
