// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the resource record sets that you want to create based on a specified traffic policy.
 */
class CreateTrafficPolicyInstanceRequest private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    val trafficPolicyId: kotlin.String? = builder.trafficPolicyId
    /**
     * The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    val trafficPolicyVersion: kotlin.Int? = builder.trafficPolicyVersion
    /**
     * (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.
     */
    val ttl: kotlin.Long? = builder.ttl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.CreateTrafficPolicyInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrafficPolicyInstanceRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("name=$name,")
        append("trafficPolicyId=$trafficPolicyId,")
        append("trafficPolicyVersion=$trafficPolicyVersion,")
        append("ttl=$ttl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyId?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyVersion ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrafficPolicyInstanceRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (name != other.name) return false
        if (trafficPolicyId != other.trafficPolicyId) return false
        if (trafficPolicyVersion != other.trafficPolicyVersion) return false
        if (ttl != other.ttl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.CreateTrafficPolicyInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
         */
        var name: kotlin.String? = null
        /**
         * The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
         */
        var trafficPolicyId: kotlin.String? = null
        /**
         * The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
         */
        var trafficPolicyVersion: kotlin.Int? = null
        /**
         * (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.
         */
        var ttl: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.CreateTrafficPolicyInstanceRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.name = x.name
            this.trafficPolicyId = x.trafficPolicyId
            this.trafficPolicyVersion = x.trafficPolicyVersion
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.CreateTrafficPolicyInstanceRequest = CreateTrafficPolicyInstanceRequest(this)
    }
}
