// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A string repesenting the status of DNSSEC signing.
 */
class DnssecStatus private constructor(builder: Builder) {
    /**
     * A string that represents the current hosted zone signing status.
     *
     * Status can have one of the following values:
     *
     * ## SIGNING
     * DNSSEC signing is enabled for the hosted zone.
     *
     * ## NOT_SIGNING
     * DNSSEC signing is not enabled for the hosted zone.
     *
     * ## DELETING
     * DNSSEC signing is in the process of being removed for the hosted zone.
     *
     * ## ACTION_NEEDED
     * There is a problem with signing in the hosted zone that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.
     *
     * ## INTERNAL_FAILURE
     * There was an error during a request. Before you can continue to work with DNSSEC signing, including with key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for the hosted zone.
     */
    val serveSignature: kotlin.String? = builder.serveSignature
    /**
     * The status message provided for the following DNSSEC signing status: `INTERNAL_FAILURE`. The status message includes information about what the problem might be and steps that you can take to correct the issue.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.DnssecStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnssecStatus(")
        append("serveSignature=$serveSignature,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = serveSignature?.hashCode() ?: 0
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnssecStatus

        if (serveSignature != other.serveSignature) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.DnssecStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * A string that represents the current hosted zone signing status.
         *
         * Status can have one of the following values:
         *
         * ## SIGNING
         * DNSSEC signing is enabled for the hosted zone.
         *
         * ## NOT_SIGNING
         * DNSSEC signing is not enabled for the hosted zone.
         *
         * ## DELETING
         * DNSSEC signing is in the process of being removed for the hosted zone.
         *
         * ## ACTION_NEEDED
         * There is a problem with signing in the hosted zone that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.
         *
         * ## INTERNAL_FAILURE
         * There was an error during a request. Before you can continue to work with DNSSEC signing, including with key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for the hosted zone.
         */
        var serveSignature: kotlin.String? = null
        /**
         * The status message provided for the following DNSSEC signing status: `INTERNAL_FAILURE`. The status message includes information about what the problem might be and steps that you can take to correct the issue.
         */
        var statusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.DnssecStatus) : this() {
            this.serveSignature = x.serveSignature
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.DnssecStatus = DnssecStatus(this)
    }
}
