// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about a geographic location.
 */
class GeoLocation private constructor(builder: Builder) {
    /**
     * The two-letter code for the continent.
     *
     * Amazon Route 53 supports the following continent codes:
     * + **AF**: Africa
     * + **AN**: Antarctica
     * + **AS**: Asia
     * + **EU**: Europe
     * + **OC**: Oceania
     * + **NA**: North America
     * + **SA**: South America
     *
     * Constraint: Specifying `ContinentCode` with either `CountryCode` or `SubdivisionCode` returns an `InvalidInput` error.
     */
    val continentCode: kotlin.String? = builder.continentCode
    /**
     * For geolocation resource record sets, the two-letter code for a country.
     *
     * Amazon Route 53 uses the two-letter country codes that are specified in [ISO standard 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
     */
    val countryCode: kotlin.String? = builder.countryCode
    /**
     * For geolocation resource record sets, the two-letter code for a state of the United States. Route 53 doesn't support any other values for `SubdivisionCode`. For a list of state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations](https://pe.usps.com/text/pub28/28apb.htm) on the United States Postal Service website.
     *
     * If you specify `subdivisioncode`, you must also specify `US` for `CountryCode`.
     */
    val subdivisionCode: kotlin.String? = builder.subdivisionCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.GeoLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoLocation(")
        append("continentCode=$continentCode,")
        append("countryCode=$countryCode,")
        append("subdivisionCode=$subdivisionCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = continentCode?.hashCode() ?: 0
        result = 31 * result + (countryCode?.hashCode() ?: 0)
        result = 31 * result + (subdivisionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoLocation

        if (continentCode != other.continentCode) return false
        if (countryCode != other.countryCode) return false
        if (subdivisionCode != other.subdivisionCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.GeoLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The two-letter code for the continent.
         *
         * Amazon Route 53 supports the following continent codes:
         * + **AF**: Africa
         * + **AN**: Antarctica
         * + **AS**: Asia
         * + **EU**: Europe
         * + **OC**: Oceania
         * + **NA**: North America
         * + **SA**: South America
         *
         * Constraint: Specifying `ContinentCode` with either `CountryCode` or `SubdivisionCode` returns an `InvalidInput` error.
         */
        var continentCode: kotlin.String? = null
        /**
         * For geolocation resource record sets, the two-letter code for a country.
         *
         * Amazon Route 53 uses the two-letter country codes that are specified in [ISO standard 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
         */
        var countryCode: kotlin.String? = null
        /**
         * For geolocation resource record sets, the two-letter code for a state of the United States. Route 53 doesn't support any other values for `SubdivisionCode`. For a list of state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations](https://pe.usps.com/text/pub28/28apb.htm) on the United States Postal Service website.
         *
         * If you specify `subdivisioncode`, you must also specify `US` for `CountryCode`.
         */
        var subdivisionCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.GeoLocation) : this() {
            this.continentCode = x.continentCode
            this.countryCode = x.countryCode
            this.subdivisionCode = x.subdivisionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.GeoLocation = GeoLocation(this)
    }
}
