// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request for information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.
 */
class GetGeoLocationRequest private constructor(builder: Builder) {
    /**
     * For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:
     * + **AF**: Africa
     * + **AN**: Antarctica
     * + **AS**: Asia
     * + **EU**: Europe
     * + **OC**: Oceania
     * + **NA**: North America
     * + **SA**: South America
     */
    val continentCode: kotlin.String? = builder.continentCode
    /**
     * Amazon Route 53 uses the two-letter country codes that are specified in [ISO standard 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
     */
    val countryCode: kotlin.String? = builder.countryCode
    /**
     * The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations](https://pe.usps.com/text/pub28/28apb.htm) on the United States Postal Service website. For a list of all supported subdivision codes, use the [ListGeoLocations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html) API.
     */
    val subdivisionCode: kotlin.String? = builder.subdivisionCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.GetGeoLocationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGeoLocationRequest(")
        append("continentCode=$continentCode,")
        append("countryCode=$countryCode,")
        append("subdivisionCode=$subdivisionCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = continentCode?.hashCode() ?: 0
        result = 31 * result + (countryCode?.hashCode() ?: 0)
        result = 31 * result + (subdivisionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGeoLocationRequest

        if (continentCode != other.continentCode) return false
        if (countryCode != other.countryCode) return false
        if (subdivisionCode != other.subdivisionCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.GetGeoLocationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:
         * + **AF**: Africa
         * + **AN**: Antarctica
         * + **AS**: Asia
         * + **EU**: Europe
         * + **OC**: Oceania
         * + **NA**: North America
         * + **SA**: South America
         */
        var continentCode: kotlin.String? = null
        /**
         * Amazon Route 53 uses the two-letter country codes that are specified in [ISO standard 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
         */
        var countryCode: kotlin.String? = null
        /**
         * The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations](https://pe.usps.com/text/pub28/28apb.htm) on the United States Postal Service website. For a list of all supported subdivision codes, use the [ListGeoLocations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html) API.
         */
        var subdivisionCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.GetGeoLocationRequest) : this() {
            this.continentCode = x.continentCode
            this.countryCode = x.countryCode
            this.subdivisionCode = x.subdivisionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.GetGeoLocationRequest = GetGeoLocationRequest(this)
    }
}
