// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the request to create a hosted zone.
 */
class GetHostedZoneLimitRequest private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone that you want to get a limit for.
     */
    val hostedZoneId: kotlin.String? = requireNotNull(builder.hostedZoneId) { "A non-null value must be provided for hostedZoneId" }
    /**
     * The limit that you want to get. Valid values include the following:
     * + **MAX_RRSETS_BY_ZONE**: The maximum number of records that you can create in the specified hosted zone.
     * + **MAX_VPCS_ASSOCIATED_BY_ZONE**: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.
     */
    val type: aws.sdk.kotlin.services.route53.model.HostedZoneLimitType? = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.GetHostedZoneLimitRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetHostedZoneLimitRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetHostedZoneLimitRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.GetHostedZoneLimitRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone that you want to get a limit for.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The limit that you want to get. Valid values include the following:
         * + **MAX_RRSETS_BY_ZONE**: The maximum number of records that you can create in the specified hosted zone.
         * + **MAX_VPCS_ASSOCIATED_BY_ZONE**: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.
         */
        var type: aws.sdk.kotlin.services.route53.model.HostedZoneLimitType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.GetHostedZoneLimitRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.GetHostedZoneLimitRequest = GetHostedZoneLimitRequest(this)
    }
}
