// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about one health check that is associated with the current Amazon Web Services account.
 */
class HealthCheck private constructor(builder: Builder) {
    /**
     * A unique string that you specified when you created the health check.
     */
    val callerReference: kotlin.String? = builder.callerReference
    /**
     * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this health check.
     */
    val cloudWatchAlarmConfiguration: aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration? = builder.cloudWatchAlarmConfiguration
    /**
     * A complex type that contains detailed information about one health check.
     */
    val healthCheckConfig: aws.sdk.kotlin.services.route53.model.HealthCheckConfig? = builder.healthCheckConfig
    /**
     * The version of the health check. You can optionally pass this value in a call to `UpdateHealthCheck` to prevent overwriting another change to the health check.
     */
    val healthCheckVersion: kotlin.Long? = builder.healthCheckVersion
    /**
     * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.
     */
    val id: kotlin.String? = builder.id
    /**
     * If the health check was created by another service, the service that created the health check. When a health check is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    val linkedService: aws.sdk.kotlin.services.route53.model.LinkedService? = builder.linkedService

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.HealthCheck = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheck(")
        append("callerReference=$callerReference,")
        append("cloudWatchAlarmConfiguration=$cloudWatchAlarmConfiguration,")
        append("healthCheckConfig=$healthCheckConfig,")
        append("healthCheckVersion=$healthCheckVersion,")
        append("id=$id,")
        append("linkedService=$linkedService)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (cloudWatchAlarmConfiguration?.hashCode() ?: 0)
        result = 31 * result + (healthCheckConfig?.hashCode() ?: 0)
        result = 31 * result + (healthCheckVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (linkedService?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheck

        if (callerReference != other.callerReference) return false
        if (cloudWatchAlarmConfiguration != other.cloudWatchAlarmConfiguration) return false
        if (healthCheckConfig != other.healthCheckConfig) return false
        if (healthCheckVersion != other.healthCheckVersion) return false
        if (id != other.id) return false
        if (linkedService != other.linkedService) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.HealthCheck = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that you specified when you created the health check.
         */
        var callerReference: kotlin.String? = null
        /**
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this health check.
         */
        var cloudWatchAlarmConfiguration: aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration? = null
        /**
         * A complex type that contains detailed information about one health check.
         */
        var healthCheckConfig: aws.sdk.kotlin.services.route53.model.HealthCheckConfig? = null
        /**
         * The version of the health check. You can optionally pass this value in a call to `UpdateHealthCheck` to prevent overwriting another change to the health check.
         */
        var healthCheckVersion: kotlin.Long? = null
        /**
         * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.
         */
        var id: kotlin.String? = null
        /**
         * If the health check was created by another service, the service that created the health check. When a health check is created by another service, you can't edit or delete it using Amazon Route 53.
         */
        var linkedService: aws.sdk.kotlin.services.route53.model.LinkedService? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.HealthCheck) : this() {
            this.callerReference = x.callerReference
            this.cloudWatchAlarmConfiguration = x.cloudWatchAlarmConfiguration
            this.healthCheckConfig = x.healthCheckConfig
            this.healthCheckVersion = x.healthCheckVersion
            this.id = x.id
            this.linkedService = x.linkedService
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.HealthCheck = HealthCheck(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration] inside the given [block]
         */
        fun cloudWatchAlarmConfiguration(block: aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudWatchAlarmConfiguration = aws.sdk.kotlin.services.route53.model.CloudWatchAlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.HealthCheckConfig] inside the given [block]
         */
        fun healthCheckConfig(block: aws.sdk.kotlin.services.route53.model.HealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckConfig = aws.sdk.kotlin.services.route53.model.HealthCheckConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.LinkedService] inside the given [block]
         */
        fun linkedService(block: aws.sdk.kotlin.services.route53.model.LinkedService.Builder.() -> kotlin.Unit) {
            this.linkedService = aws.sdk.kotlin.services.route53.model.LinkedService.invoke(block)
        }
    }
}
