// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains general information about the hosted zone.
 */
class HostedZone private constructor(builder: Builder) {
    /**
     * The value that you specified for `CallerReference` when you created the hosted zone.
     */
    val callerReference: kotlin.String? = builder.callerReference
    /**
     * A complex type that includes the `Comment` and `PrivateZone` elements. If you omitted the `HostedZoneConfig` and `Comment` elements from the request, the `Config` and `Comment` elements don't appear in the response.
     */
    val config: aws.sdk.kotlin.services.route53.model.HostedZoneConfig? = builder.config
    /**
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    val id: kotlin.String? = builder.id
    /**
     * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted zone is created by another service, you can't edit or delete it using Route 53.
     */
    val linkedService: aws.sdk.kotlin.services.route53.model.LinkedService? = builder.linkedService
    /**
     * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS registrar.
     *
     * For information about how to specify characters other than `a-z`, `0-9`, and `-` (hyphen) and how to specify internationalized domain names, see [CreateHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html).
     */
    val name: kotlin.String? = builder.name
    /**
     * The number of resource record sets in the hosted zone.
     */
    val resourceRecordSetCount: kotlin.Long? = builder.resourceRecordSetCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.HostedZone = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HostedZone(")
        append("callerReference=$callerReference,")
        append("config=$config,")
        append("id=$id,")
        append("linkedService=$linkedService,")
        append("name=$name,")
        append("resourceRecordSetCount=$resourceRecordSetCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (config?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (linkedService?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceRecordSetCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HostedZone

        if (callerReference != other.callerReference) return false
        if (config != other.config) return false
        if (id != other.id) return false
        if (linkedService != other.linkedService) return false
        if (name != other.name) return false
        if (resourceRecordSetCount != other.resourceRecordSetCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.HostedZone = Builder(this).apply(block).build()

    class Builder {
        /**
         * The value that you specified for `CallerReference` when you created the hosted zone.
         */
        var callerReference: kotlin.String? = null
        /**
         * A complex type that includes the `Comment` and `PrivateZone` elements. If you omitted the `HostedZoneConfig` and `Comment` elements from the request, the `Config` and `Comment` elements don't appear in the response.
         */
        var config: aws.sdk.kotlin.services.route53.model.HostedZoneConfig? = null
        /**
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         */
        var id: kotlin.String? = null
        /**
         * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted zone is created by another service, you can't edit or delete it using Route 53.
         */
        var linkedService: aws.sdk.kotlin.services.route53.model.LinkedService? = null
        /**
         * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS registrar.
         *
         * For information about how to specify characters other than `a-z`, `0-9`, and `-` (hyphen) and how to specify internationalized domain names, see [CreateHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html).
         */
        var name: kotlin.String? = null
        /**
         * The number of resource record sets in the hosted zone.
         */
        var resourceRecordSetCount: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.HostedZone) : this() {
            this.callerReference = x.callerReference
            this.config = x.config
            this.id = x.id
            this.linkedService = x.linkedService
            this.name = x.name
            this.resourceRecordSetCount = x.resourceRecordSetCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.HostedZone = HostedZone(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.HostedZoneConfig] inside the given [block]
         */
        fun config(block: aws.sdk.kotlin.services.route53.model.HostedZoneConfig.Builder.() -> kotlin.Unit) {
            this.config = aws.sdk.kotlin.services.route53.model.HostedZoneConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.LinkedService] inside the given [block]
         */
        fun linkedService(block: aws.sdk.kotlin.services.route53.model.LinkedService.Builder.() -> kotlin.Unit) {
            this.linkedService = aws.sdk.kotlin.services.route53.model.LinkedService.invoke(block)
        }
    }
}
