// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that identifies a hosted zone that a specified Amazon VPC is associated with and the owner of the hosted zone. If there is a value for `OwningAccount`, there is no value for `OwningService`, and vice versa.
 */
class HostedZoneOwner private constructor(builder: Builder) {
    /**
     * If the hosted zone was created by an Amazon Web Services account, or was created by an Amazon Web Services service that creates hosted zones using the current account, `OwningAccount` contains the account ID of that account. For example, when you use Cloud Map to create a hosted zone, Cloud Map creates the hosted zone using the current Amazon Web Services account.
     */
    val owningAccount: kotlin.String? = builder.owningAccount
    /**
     * If an Amazon Web Services service uses its own account to create a hosted zone and associate the specified VPC with that hosted zone, `OwningService` contains an abbreviation that identifies the service. For example, if Amazon Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with the hosted zone, the value of `OwningService` is `efs.amazonaws.com`.
     */
    val owningService: kotlin.String? = builder.owningService

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.HostedZoneOwner = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HostedZoneOwner(")
        append("owningAccount=$owningAccount,")
        append("owningService=$owningService)")
    }

    override fun hashCode(): kotlin.Int {
        var result = owningAccount?.hashCode() ?: 0
        result = 31 * result + (owningService?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HostedZoneOwner

        if (owningAccount != other.owningAccount) return false
        if (owningService != other.owningService) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.HostedZoneOwner = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the hosted zone was created by an Amazon Web Services account, or was created by an Amazon Web Services service that creates hosted zones using the current account, `OwningAccount` contains the account ID of that account. For example, when you use Cloud Map to create a hosted zone, Cloud Map creates the hosted zone using the current Amazon Web Services account.
         */
        var owningAccount: kotlin.String? = null
        /**
         * If an Amazon Web Services service uses its own account to create a hosted zone and associate the specified VPC with that hosted zone, `OwningService` contains an abbreviation that identifies the service. For example, if Amazon Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with the hosted zone, the value of `OwningService` is `efs.amazonaws.com`.
         */
        var owningService: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.HostedZoneOwner) : this() {
            this.owningAccount = x.owningAccount
            this.owningService = x.owningService
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.HostedZoneOwner = HostedZoneOwner(this)
    }
}
