// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * In the response to a `ListHostedZonesByVPC` request, the `HostedZoneSummaries` element contains one `HostedZoneSummary` element for each hosted zone that the specified Amazon VPC is associated with. Each `HostedZoneSummary` element contains the hosted zone name and ID, and information about who owns the hosted zone.
 */
class HostedZoneSummary private constructor(builder: Builder) {
    /**
     * The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The name of the private hosted zone, such as `example.com`.
     */
    val name: kotlin.String? = builder.name
    /**
     * The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an Amazon Web Services account or an Amazon Web Services service.
     */
    val owner: aws.sdk.kotlin.services.route53.model.HostedZoneOwner? = builder.owner

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.HostedZoneSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HostedZoneSummary(")
        append("hostedZoneId=$hostedZoneId,")
        append("name=$name,")
        append("owner=$owner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HostedZoneSummary

        if (hostedZoneId != other.hostedZoneId) return false
        if (name != other.name) return false
        if (owner != other.owner) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.HostedZoneSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The name of the private hosted zone, such as `example.com`.
         */
        var name: kotlin.String? = null
        /**
         * The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an Amazon Web Services account or an Amazon Web Services service.
         */
        var owner: aws.sdk.kotlin.services.route53.model.HostedZoneOwner? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.HostedZoneSummary) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.name = x.name
            this.owner = x.owner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.HostedZoneSummary = HostedZoneSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53.model.HostedZoneOwner] inside the given [block]
         */
        fun owner(block: aws.sdk.kotlin.services.route53.model.HostedZoneOwner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.route53.model.HostedZoneOwner.invoke(block)
        }
    }
}
