// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log streams. Possible causes include the following:
 * + There is no resource policy that specifies the log group ARN in the value for `Resource`.
 * + The resource policy that includes the log group ARN in the value for `Resource` doesn't have the necessary permissions.
 * + The resource policy hasn't finished propagating yet.
 * + The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the log group associated with query log. Update or provide a resource policy to grant permissions for the KMS key.
 */
class InsufficientCloudWatchLogsResourcePolicy private constructor(builder: Builder) : Route53Exception() {

    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.InsufficientCloudWatchLogsResourcePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsufficientCloudWatchLogsResourcePolicy(")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsufficientCloudWatchLogsResourcePolicy

        if (message != other.message) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.InsufficientCloudWatchLogsResourcePolicy = Builder(this).apply(block).build()

    class Builder {
        var message: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.InsufficientCloudWatchLogsResourcePolicy) : this() {
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.InsufficientCloudWatchLogsResourcePolicy = InsufficientCloudWatchLogsResourcePolicy(this)
    }
}
