// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A key-signing key (KSK) is a complex type that represents a public/private key pair. The private key is used to generate a digital signature for the zone signing key (ZSK). The public key is stored in the DNS and is used to authenticate the ZSK. A KSK is always associated with a hosted zone; it cannot exist by itself.
 */
class KeySigningKey private constructor(builder: Builder) {
    /**
     * The date when the key-signing key (KSK) was created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     */
    val digestAlgorithmMnemonic: kotlin.String? = builder.digestAlgorithmMnemonic
    /**
     * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     */
    val digestAlgorithmType: kotlin.Int = builder.digestAlgorithmType
    /**
     * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
     */
    val digestValue: kotlin.String? = builder.digestValue
    /**
     * A string that represents a DNSKEY record.
     */
    val dnskeyRecord: kotlin.String? = builder.dnskeyRecord
    /**
     * A string that represents a delegation signer (DS) record.
     */
    val dsRecord: kotlin.String? = builder.dsRecord
    /**
     * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     */
    val flag: kotlin.Int = builder.flag
    /**
     * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
     */
    val keyTag: kotlin.Int = builder.keyTag
    /**
     * The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service (KMS). The `KmsArn` must be unique for each key-signing key (KSK) in a single hosted zone.
     *
     * You must configure the customer managed key as follows:
     *
     * ## Status
     * Enabled
     *
     * ## Key spec
     * ECC_NIST_P256
     *
     * ## Key usage
     * Sign and verify
     *
     * ## Key policy
     * The key policy must give permission for the following actions:
     * + DescribeKey
     * + GetPublicKey
     * + Sign
     * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:
     * + `"Service": "dnssec-route53.amazonaws.com"`
     *
     * For more information about working with the customer managed key in KMS, see [Key Management Service concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
     */
    val kmsArn: kotlin.String? = builder.kmsArn
    /**
     * The last time that the key-signing key (KSK) was changed.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * A string used to identify a key-signing key (KSK). `Name` can include numbers, letters, and underscores (_). `Name` must be unique for each key-signing key in the same hosted zone.
     */
    val name: kotlin.String? = builder.name
    /**
     * The public key, represented as a Base64 encoding, as required by [ RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
     */
    val publicKey: kotlin.String? = builder.publicKey
    /**
     * A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     */
    val signingAlgorithmMnemonic: kotlin.String? = builder.signingAlgorithmMnemonic
    /**
     * An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     */
    val signingAlgorithmType: kotlin.Int = builder.signingAlgorithmType
    /**
     * A string that represents the current key-signing key (KSK) status.
     *
     * Status can have one of the following values:
     *
     * ## ACTIVE
     * The KSK is being used for signing.
     *
     * ## INACTIVE
     * The KSK is not being used for signing.
     *
     * ## DELETING
     * The KSK is in the process of being deleted.
     *
     * ## ACTION_NEEDED
     * There is a problem with the KSK that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.
     *
     * ## INTERNAL_FAILURE
     * There was an error during a request. Before you can continue to work with DNSSEC signing, including actions that involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the KSK.
     */
    val status: kotlin.String? = builder.status
    /**
     * The status message provided for the following key-signing key (KSK) statuses: `ACTION_NEEDED` or `INTERNAL_FAILURE`. The status message includes information about what the problem might be and steps that you can take to correct the issue.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.KeySigningKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeySigningKey(")
        append("createdDate=$createdDate,")
        append("digestAlgorithmMnemonic=$digestAlgorithmMnemonic,")
        append("digestAlgorithmType=$digestAlgorithmType,")
        append("digestValue=$digestValue,")
        append("dnskeyRecord=$dnskeyRecord,")
        append("dsRecord=$dsRecord,")
        append("flag=$flag,")
        append("keyTag=$keyTag,")
        append("kmsArn=$kmsArn,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("name=$name,")
        append("publicKey=$publicKey,")
        append("signingAlgorithmMnemonic=$signingAlgorithmMnemonic,")
        append("signingAlgorithmType=$signingAlgorithmType,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (digestAlgorithmMnemonic?.hashCode() ?: 0)
        result = 31 * result + (digestAlgorithmType)
        result = 31 * result + (digestValue?.hashCode() ?: 0)
        result = 31 * result + (dnskeyRecord?.hashCode() ?: 0)
        result = 31 * result + (dsRecord?.hashCode() ?: 0)
        result = 31 * result + (flag)
        result = 31 * result + (keyTag)
        result = 31 * result + (kmsArn?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publicKey?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithmMnemonic?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithmType)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeySigningKey

        if (createdDate != other.createdDate) return false
        if (digestAlgorithmMnemonic != other.digestAlgorithmMnemonic) return false
        if (digestAlgorithmType != other.digestAlgorithmType) return false
        if (digestValue != other.digestValue) return false
        if (dnskeyRecord != other.dnskeyRecord) return false
        if (dsRecord != other.dsRecord) return false
        if (flag != other.flag) return false
        if (keyTag != other.keyTag) return false
        if (kmsArn != other.kmsArn) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (name != other.name) return false
        if (publicKey != other.publicKey) return false
        if (signingAlgorithmMnemonic != other.signingAlgorithmMnemonic) return false
        if (signingAlgorithmType != other.signingAlgorithmType) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.KeySigningKey = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date when the key-signing key (KSK) was created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         */
        var digestAlgorithmMnemonic: kotlin.String? = null
        /**
         * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         */
        var digestAlgorithmType: kotlin.Int = 0
        /**
         * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
         */
        var digestValue: kotlin.String? = null
        /**
         * A string that represents a DNSKEY record.
         */
        var dnskeyRecord: kotlin.String? = null
        /**
         * A string that represents a delegation signer (DS) record.
         */
        var dsRecord: kotlin.String? = null
        /**
         * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
         */
        var flag: kotlin.Int = 0
        /**
         * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
         */
        var keyTag: kotlin.Int = 0
        /**
         * The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service (KMS). The `KmsArn` must be unique for each key-signing key (KSK) in a single hosted zone.
         *
         * You must configure the customer managed key as follows:
         *
         * ## Status
         * Enabled
         *
         * ## Key spec
         * ECC_NIST_P256
         *
         * ## Key usage
         * Sign and verify
         *
         * ## Key policy
         * The key policy must give permission for the following actions:
         * + DescribeKey
         * + GetPublicKey
         * + Sign
         * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:
         * + `"Service": "dnssec-route53.amazonaws.com"`
         *
         * For more information about working with the customer managed key in KMS, see [Key Management Service concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
         */
        var kmsArn: kotlin.String? = null
        /**
         * The last time that the key-signing key (KSK) was changed.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A string used to identify a key-signing key (KSK). `Name` can include numbers, letters, and underscores (_). `Name` must be unique for each key-signing key in the same hosted zone.
         */
        var name: kotlin.String? = null
        /**
         * The public key, represented as a Base64 encoding, as required by [ RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
         */
        var publicKey: kotlin.String? = null
        /**
         * A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         */
        var signingAlgorithmMnemonic: kotlin.String? = null
        /**
         * An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         */
        var signingAlgorithmType: kotlin.Int = 0
        /**
         * A string that represents the current key-signing key (KSK) status.
         *
         * Status can have one of the following values:
         *
         * ## ACTIVE
         * The KSK is being used for signing.
         *
         * ## INACTIVE
         * The KSK is not being used for signing.
         *
         * ## DELETING
         * The KSK is in the process of being deleted.
         *
         * ## ACTION_NEEDED
         * There is a problem with the KSK that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.
         *
         * ## INTERNAL_FAILURE
         * There was an error during a request. Before you can continue to work with DNSSEC signing, including actions that involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the KSK.
         */
        var status: kotlin.String? = null
        /**
         * The status message provided for the following key-signing key (KSK) statuses: `ACTION_NEEDED` or `INTERNAL_FAILURE`. The status message includes information about what the problem might be and steps that you can take to correct the issue.
         */
        var statusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.KeySigningKey) : this() {
            this.createdDate = x.createdDate
            this.digestAlgorithmMnemonic = x.digestAlgorithmMnemonic
            this.digestAlgorithmType = x.digestAlgorithmType
            this.digestValue = x.digestValue
            this.dnskeyRecord = x.dnskeyRecord
            this.dsRecord = x.dsRecord
            this.flag = x.flag
            this.keyTag = x.keyTag
            this.kmsArn = x.kmsArn
            this.lastModifiedDate = x.lastModifiedDate
            this.name = x.name
            this.publicKey = x.publicKey
            this.signingAlgorithmMnemonic = x.signingAlgorithmMnemonic
            this.signingAlgorithmType = x.signingAlgorithmType
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.KeySigningKey = KeySigningKey(this)
    }
}
