// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource record sets.
 */
class ListGeoLocationsRequest private constructor(builder: Builder) {
    /**
     * (Optional) The maximum number of geolocations to be included in the response body for this request. If more than `maxitems` geolocations remain to be listed, then the value of the `IsTruncated` element in the response is `true`.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is true, and if `NextContinentCode` from the previous response has a value, enter that value in `startcontinentcode` to return the next page of results.
     *
     * Include `startcontinentcode` only if you want to list continents. Don't include `startcontinentcode` when you're listing countries or countries with their subdivisions.
     */
    val startContinentCode: kotlin.String? = builder.startContinentCode
    /**
     * The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is `true`, and if `NextCountryCode` from the previous response has a value, enter that value in `startcountrycode` to return the next page of results.
     */
    val startCountryCode: kotlin.String? = builder.startCountryCode
    /**
     * The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is `true`, and if `NextSubdivisionCode` from the previous response has a value, enter that value in `startsubdivisioncode` to return the next page of results.
     *
     * To list subdivisions (U.S. states), you must include both `startcountrycode` and `startsubdivisioncode`.
     */
    val startSubdivisionCode: kotlin.String? = builder.startSubdivisionCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListGeoLocationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGeoLocationsRequest(")
        append("maxItems=$maxItems,")
        append("startContinentCode=$startContinentCode,")
        append("startCountryCode=$startCountryCode,")
        append("startSubdivisionCode=$startSubdivisionCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxItems ?: 0
        result = 31 * result + (startContinentCode?.hashCode() ?: 0)
        result = 31 * result + (startCountryCode?.hashCode() ?: 0)
        result = 31 * result + (startSubdivisionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGeoLocationsRequest

        if (maxItems != other.maxItems) return false
        if (startContinentCode != other.startContinentCode) return false
        if (startCountryCode != other.startCountryCode) return false
        if (startSubdivisionCode != other.startSubdivisionCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListGeoLocationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) The maximum number of geolocations to be included in the response body for this request. If more than `maxitems` geolocations remain to be listed, then the value of the `IsTruncated` element in the response is `true`.
         */
        var maxItems: kotlin.Int? = null
        /**
         * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is true, and if `NextContinentCode` from the previous response has a value, enter that value in `startcontinentcode` to return the next page of results.
         *
         * Include `startcontinentcode` only if you want to list continents. Don't include `startcontinentcode` when you're listing countries or countries with their subdivisions.
         */
        var startContinentCode: kotlin.String? = null
        /**
         * The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is `true`, and if `NextCountryCode` from the previous response has a value, enter that value in `startcountrycode` to return the next page of results.
         */
        var startCountryCode: kotlin.String? = null
        /**
         * The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if `IsTruncated` is `true`, and if `NextSubdivisionCode` from the previous response has a value, enter that value in `startsubdivisioncode` to return the next page of results.
         *
         * To list subdivisions (U.S. states), you must include both `startcountrycode` and `startsubdivisioncode`.
         */
        var startSubdivisionCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListGeoLocationsRequest) : this() {
            this.maxItems = x.maxItems
            this.startContinentCode = x.startContinentCode
            this.startCountryCode = x.startCountryCode
            this.startSubdivisionCode = x.startSubdivisionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListGeoLocationsRequest = ListGeoLocationsRequest(this)
    }
}
