// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type containing the response information for the request.
 */
class ListGeoLocationsResponse private constructor(builder: Builder) {
    /**
     * A complex type that contains one `GeoLocationDetails` element for each location that Amazon Route 53 supports for geolocation.
     */
    val geoLocationDetailsList: List<GeoLocationDetails>? = builder.geoLocationDetailsList
    /**
     * A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of `IsTruncated` is `true`. To get more values, submit another request and include the values of `NextContinentCode`, `NextCountryCode`, and `NextSubdivisionCode` in the `startcontinentcode`, `startcountrycode`, and `startsubdivisioncode`, as applicable.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The value that you specified for `MaxItems` in the request.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextContinentCode` in the `startcontinentcode` parameter in another `ListGeoLocations` request.
     */
    val nextContinentCode: kotlin.String? = builder.nextContinentCode
    /**
     * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextCountryCode` in the `startcountrycode` parameter in another `ListGeoLocations` request.
     */
    val nextCountryCode: kotlin.String? = builder.nextCountryCode
    /**
     * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextSubdivisionCode` in the `startsubdivisioncode` parameter in another `ListGeoLocations` request.
     */
    val nextSubdivisionCode: kotlin.String? = builder.nextSubdivisionCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListGeoLocationsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGeoLocationsResponse(")
        append("geoLocationDetailsList=$geoLocationDetailsList,")
        append("isTruncated=$isTruncated,")
        append("maxItems=$maxItems,")
        append("nextContinentCode=$nextContinentCode,")
        append("nextCountryCode=$nextCountryCode,")
        append("nextSubdivisionCode=$nextSubdivisionCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = geoLocationDetailsList?.hashCode() ?: 0
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextContinentCode?.hashCode() ?: 0)
        result = 31 * result + (nextCountryCode?.hashCode() ?: 0)
        result = 31 * result + (nextSubdivisionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGeoLocationsResponse

        if (geoLocationDetailsList != other.geoLocationDetailsList) return false
        if (isTruncated != other.isTruncated) return false
        if (maxItems != other.maxItems) return false
        if (nextContinentCode != other.nextContinentCode) return false
        if (nextCountryCode != other.nextCountryCode) return false
        if (nextSubdivisionCode != other.nextSubdivisionCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListGeoLocationsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A complex type that contains one `GeoLocationDetails` element for each location that Amazon Route 53 supports for geolocation.
         */
        var geoLocationDetailsList: List<GeoLocationDetails>? = null
        /**
         * A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of `IsTruncated` is `true`. To get more values, submit another request and include the values of `NextContinentCode`, `NextCountryCode`, and `NextSubdivisionCode` in the `startcontinentcode`, `startcountrycode`, and `startsubdivisioncode`, as applicable.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The value that you specified for `MaxItems` in the request.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextContinentCode` in the `startcontinentcode` parameter in another `ListGeoLocations` request.
         */
        var nextContinentCode: kotlin.String? = null
        /**
         * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextCountryCode` in the `startcountrycode` parameter in another `ListGeoLocations` request.
         */
        var nextCountryCode: kotlin.String? = null
        /**
         * If `IsTruncated` is `true`, you can make a follow-up request to display more locations. Enter the value of `NextSubdivisionCode` in the `startsubdivisioncode` parameter in another `ListGeoLocations` request.
         */
        var nextSubdivisionCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListGeoLocationsResponse) : this() {
            this.geoLocationDetailsList = x.geoLocationDetailsList
            this.isTruncated = x.isTruncated
            this.maxItems = x.maxItems
            this.nextContinentCode = x.nextContinentCode
            this.nextCountryCode = x.nextCountryCode
            this.nextSubdivisionCode = x.nextSubdivisionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListGeoLocationsResponse = ListGeoLocationsResponse(this)
    }
}
