// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request to retrieve a list of the health checks that are associated with the current Amazon Web Services account.
 */
class ListHealthChecksRequest private constructor(builder: Builder) {
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more health checks. To get another group, submit another `ListHealthChecks` request.
     *
     * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more health checks to get.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of health checks that you want `ListHealthChecks` to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set `MaxItems` to a value greater than 100, Route 53 returns only the first 100 health checks.
     */
    val maxItems: kotlin.Int? = builder.maxItems

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHealthChecksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHealthChecksRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHealthChecksRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHealthChecksRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more health checks. To get another group, submit another `ListHealthChecks` request.
         *
         * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more health checks to get.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of health checks that you want `ListHealthChecks` to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set `MaxItems` to a value greater than 100, Route 53 returns only the first 100 health checks.
         */
        var maxItems: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHealthChecksRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHealthChecksRequest = ListHealthChecksRequest(this)
    }
}
