// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the response to a `ListHealthChecks` request.
 */
class ListHealthChecksResponse private constructor(builder: Builder) {
    /**
     * A complex type that contains one `HealthCheck` element for each health check that is associated with the current Amazon Web Services account.
     */
    val healthChecks: List<HealthCheck>? = builder.healthChecks
    /**
     * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another `ListHealthChecks` request and specifying the value of `NextMarker` in the `marker` parameter.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * For the second and subsequent calls to `ListHealthChecks`, `Marker` is the value that you specified for the `marker` parameter in the previous request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The value that you specified for the `maxitems` parameter in the call to `ListHealthChecks` that produced the current response.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is `true`, the value of `NextMarker` identifies the first health check that Amazon Route 53 returns if you submit another `ListHealthChecks` request and specify the value of `NextMarker` in the `marker` parameter.
     */
    val nextMarker: kotlin.String? = builder.nextMarker

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHealthChecksResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHealthChecksResponse(")
        append("healthChecks=$healthChecks,")
        append("isTruncated=$isTruncated,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthChecks?.hashCode() ?: 0
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHealthChecksResponse

        if (healthChecks != other.healthChecks) return false
        if (isTruncated != other.isTruncated) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHealthChecksResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A complex type that contains one `HealthCheck` element for each health check that is associated with the current Amazon Web Services account.
         */
        var healthChecks: List<HealthCheck>? = null
        /**
         * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another `ListHealthChecks` request and specifying the value of `NextMarker` in the `marker` parameter.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * For the second and subsequent calls to `ListHealthChecks`, `Marker` is the value that you specified for the `marker` parameter in the previous request.
         */
        var marker: kotlin.String? = null
        /**
         * The value that you specified for the `maxitems` parameter in the call to `ListHealthChecks` that produced the current response.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, the value of `NextMarker` identifies the first health check that Amazon Route 53 returns if you submit another `ListHealthChecks` request and specify the value of `NextMarker` in the `marker` parameter.
         */
        var nextMarker: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHealthChecksResponse) : this() {
            this.healthChecks = x.healthChecks
            this.isTruncated = x.isTruncated
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHealthChecksResponse = ListHealthChecksResponse(this)
    }
}
